/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLConstants;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import net.shibboleth.utilities.java.support.xml.XMLSpace;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AttributeSupportTest {
    @Nonnull
    @NotEmpty
    private static final String TEST_NS = "http://example.org/NameSpace";
    @Nonnull
    @NotEmpty
    private static final String TEST_PREFIX = "testns";
    @Nonnull
    @NotEmpty
    private static final String TEST_ID_ATTRIBUTE = "testAttributeName";
    @Nonnull
    @NotEmpty
    private static final String TEST_ID_PREFIXEDATTRIBUTE = "testns:testAttributeName";
    @Nonnull
    @NotEmpty
    private static final String TEST_ID_ATTRIBUTE_VALUE = "IDAttrVALUE";
    private QName idAttrQName;
    private Element goodBaseIdSpaceLang;
    private Element noBaseIdSpaceLang;
    private Element badSpace;
    private Element preserveSpace;
    private Element attributes;
    private Element createdElement;
    private Document document;
    private BasicParserPool parserPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public void setUp() throws XMLParserException, ComponentInitializationException, SAXException, IOException {
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            this.idAttrQName = new QName(TEST_NS, TEST_ID_ATTRIBUTE, TEST_PREFIX);
            ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/attributeSupportTest.xml");
            Document testFile = builder.parse(resource.getInputStream());
            Element root = (Element)testFile.getFirstChild();
            this.goodBaseIdSpaceLang = (Element)root.getFirstChild().getNextSibling();
            Assert.assertEquals((String)this.goodBaseIdSpaceLang.getLocalName(), (String)"GoodBaseIdSpaceLang");
            this.noBaseIdSpaceLang = (Element)this.goodBaseIdSpaceLang.getNextSibling().getNextSibling();
            Assert.assertEquals((String)this.noBaseIdSpaceLang.getLocalName(), (String)"NoBaseIdSpaceLang");
            this.badSpace = (Element)this.noBaseIdSpaceLang.getNextSibling().getNextSibling();
            Assert.assertEquals((String)this.badSpace.getLocalName(), (String)"BadSpace");
            this.preserveSpace = (Element)this.badSpace.getNextSibling().getNextSibling();
            Assert.assertEquals((String)this.preserveSpace.getLocalName(), (String)"PreserveSpace");
            this.attributes = (Element)this.preserveSpace.getNextSibling().getNextSibling();
            Assert.assertEquals((String)this.attributes.getLocalName(), (String)"AttributeTest");
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void resetCreatedElement() throws XMLParserException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            this.document = builder.newDocument();
            this.createdElement = this.document.createElement("TestElement");
            Attr attr = this.document.createAttributeNS(TEST_NS, TEST_ID_PREFIXEDATTRIBUTE);
            attr.setValue(TEST_ID_ATTRIBUTE_VALUE);
            Element el = this.document.createElement("ChildElement");
            el.setAttributeNode(attr);
            el.setIdAttributeNode(attr, true);
            this.createdElement.appendChild(el);
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testBadNS() throws XMLParserException, ComponentInitializationException, IOException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/badNS1.xml");
        boolean thrown = false;
        Document file = null;
        try {
            file = builder.parse(resource.getInputStream());
        }
        catch (SAXException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"xmlns: declaration with name other than xml and namespace of http://www.w3.org/XML/1998/namespace should throw an error ");
        resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/badNS2.xml");
        thrown = false;
        try {
            file = builder.parse(resource.getInputStream());
        }
        catch (SAXException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"xmlns:xml with namespace other than http://www.w3.org/XML/1998/namespace should throw an error ");
        Assert.assertNull((Object)file, (String)"shut up compiler");
        this.parserPool.returnBuilder(builder);
    }

    @Test
    public void testGetXMLId() {
        Assert.assertEquals((String)AttributeSupport.getXMLId((Element)this.goodBaseIdSpaceLang), (String)"identifierGoodBaseIdSpaceLang", (String)"Identifier mismatch");
        Assert.assertNull((Object)AttributeSupport.getXMLId((Element)this.noBaseIdSpaceLang), (String)"Identifier found erroneously");
        Assert.assertEquals((String)AttributeSupport.getXMLId((Element)this.badSpace), (String)"identifierBadSpace", (String)"Identifier mismatch");
        Assert.assertEquals((String)AttributeSupport.getXMLId((Element)this.preserveSpace), (String)"identifierPreserveSpace", (String)"Identifier mismatch");
        boolean thrown = false;
        try {
            AttributeSupport.addXMLId((Element)this.createdElement, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string to addXMLId");
        thrown = false;
        try {
            AttributeSupport.addXMLId((Element)((Element)this.nullValue()), (String)"fr");
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element to addXMLId");
        Assert.assertNull((Object)AttributeSupport.getXMLId((Element)this.createdElement), (String)"xml:space found erroneously (test setup failure)");
        AttributeSupport.addXMLId((Element)this.createdElement, (String)TEST_ID_ATTRIBUTE_VALUE);
        Assert.assertEquals((String)AttributeSupport.getXMLId((Element)this.createdElement), (String)TEST_ID_ATTRIBUTE_VALUE, (String)"addXMLId failed");
    }

    @Test
    public void testXMLBase() {
        Assert.assertEquals((String)AttributeSupport.getXMLBase((Element)this.goodBaseIdSpaceLang), (String)"http://example.org/base", (String)"xml:base mismatch");
        Assert.assertNull((Object)AttributeSupport.getXMLBase((Element)this.noBaseIdSpaceLang), (String)"xml:base found erroneously");
        boolean thrown = false;
        try {
            AttributeSupport.addXMLBase((Element)this.createdElement, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string to addXMLBase");
        thrown = false;
        try {
            AttributeSupport.addXMLBase((Element)((Element)this.nullValue()), (String)"foo");
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element to addXMLBase");
        Assert.assertNull((Object)AttributeSupport.getXMLBase((Element)this.createdElement), (String)"xml:base found erroneously (test setup failure)");
        AttributeSupport.addXMLBase((Element)this.createdElement, (String)TEST_NS);
        Assert.assertEquals((String)AttributeSupport.getXMLBase((Element)this.createdElement), (String)TEST_NS, (String)"addXMLBase failed");
    }

    @Test
    public void testXMLSpace() {
        Assert.assertEquals((Object)AttributeSupport.getXMLSpace((Element)this.goodBaseIdSpaceLang), (Object)XMLSpace.DEFAULT, (String)"xml:space mismatch");
        Assert.assertNull((Object)AttributeSupport.getXMLSpace((Element)this.noBaseIdSpaceLang), (String)"xml:space found erroneously");
        Assert.assertNull((Object)AttributeSupport.getXMLSpace((Element)this.badSpace), (String)"xml:space found erroneously");
        Assert.assertEquals((Object)AttributeSupport.getXMLSpace((Element)this.preserveSpace), (Object)XMLSpace.PRESERVE, (String)"xml:space mismatch");
        boolean thrown = false;
        try {
            AttributeSupport.addXMLSpace((Element)this.createdElement, (XMLSpace)((XMLSpace)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string to addXMLBase");
        thrown = false;
        try {
            AttributeSupport.addXMLSpace((Element)((Element)this.nullValue()), (XMLSpace)XMLSpace.DEFAULT);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element to addXMLSpace");
        Assert.assertNull((Object)AttributeSupport.getXMLSpace((Element)this.createdElement), (String)"xml:space found erroneously (test setup failure)");
        AttributeSupport.addXMLSpace((Element)this.createdElement, (XMLSpace)XMLSpace.DEFAULT);
        Assert.assertEquals((Object)AttributeSupport.getXMLSpace((Element)this.createdElement), (Object)XMLSpace.DEFAULT, (String)"addXMLSpace failed");
    }

    @Test
    public void testXMLLang() {
        Assert.assertEquals((String)AttributeSupport.getXMLLang((Element)this.goodBaseIdSpaceLang), (String)"fr-ca", (String)"xml:lang mismatch");
        Assert.assertNull((Object)AttributeSupport.getXMLLang((Element)this.noBaseIdSpaceLang), (String)"xml:lang found erroneously");
        boolean thrown = false;
        try {
            AttributeSupport.addXMLLang((Element)this.createdElement, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string to addXMLBase");
        thrown = false;
        try {
            AttributeSupport.addXMLLang((Element)((Element)this.nullValue()), (String)"fr");
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element to addXMLLang");
        Assert.assertNull((Object)AttributeSupport.getXMLLang((Element)this.createdElement), (String)"xml:space found erroneously (test setup failure)");
        AttributeSupport.addXMLLang((Element)this.createdElement, (String)"fr");
        Assert.assertEquals((String)AttributeSupport.getXMLLang((Element)this.createdElement), (String)"fr", (String)"addXMLLang failed");
    }

    @Test
    public void testGetID() {
        Assert.assertNull((Object)AttributeSupport.getIdAttribute(null), (String)"ID of null is null");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"ID of non id'd element is null");
        Attr attr = AttributeSupport.getIdAttribute((Element)((Element)this.createdElement.getFirstChild()));
        Assert.assertEquals((String)attr.getValue(), (String)TEST_ID_ATTRIBUTE_VALUE, (String)"ID Attribute value mismatch");
        Assert.assertEquals((String)attr.getName(), (String)TEST_ID_PREFIXEDATTRIBUTE, (String)"ID Attribute name mismatch");
        Assert.assertEquals((String)attr.getNamespaceURI(), (String)TEST_NS, (String)"ID Attribute namespace mismatch");
    }

    @Test
    public void testHasAttribute() {
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute(null, (QName)this.idAttrQName));
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, null));
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, (QName)this.idAttrQName), (String)"Attribute lookup by QName");
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)this.goodBaseIdSpaceLang, (QName)XMLConstants.XML_BASE_ATTRIB_NAME), (String)"attribute lookup by QName from file");
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)this.noBaseIdSpaceLang, (QName)XMLConstants.XML_BASE_ATTRIB_NAME), (String)"attribute lookup by QName from file");
        Element child = (Element)this.createdElement.getFirstChild();
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)child, (QName)this.idAttrQName), (String)"attribute lookup by QName in created element");
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)child, (QName)new QName(TEST_NS, TEST_ID_ATTRIBUTE, "xxtestns")), (String)"attribute lookup by QName with changed prefix in created element");
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)child, (QName)new QName("http://example.org/NameSpace/f", TEST_ID_ATTRIBUTE, TEST_PREFIX)), (String)"attribute lookup by QName with changed NS in created element");
    }

    @Test(dependsOnMethods={"testHasAttribute"})
    public void testConstructAttribute() {
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, (QName)this.idAttrQName), (String)"precondition");
        this.createdElement.setAttributeNode(AttributeSupport.constructAttribute((Document)this.document, (QName)this.idAttrQName));
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, (QName)this.idAttrQName), (String)"test constructAttribute(QName)");
        QName testQName = new QName(TEST_NS, "testAttributeNameXX", TEST_PREFIX);
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, (QName)testQName), (String)"precondition");
        this.createdElement.setAttributeNode(AttributeSupport.constructAttribute((Document)this.document, (String)TEST_NS, (String)"testAttributeNameXX", (String)TEST_PREFIX));
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)this.createdElement, (QName)testQName), (String)"test constructAttribute(QName)");
    }

    @Test
    public void testRemoveAttribute() {
        Assert.assertFalse((boolean)AttributeSupport.removeAttribute((Element)this.createdElement, (QName)this.idAttrQName), (String)"Attribute remove by QName");
        Element child = (Element)this.createdElement.getFirstChild();
        Assert.assertTrue((boolean)AttributeSupport.removeAttribute((Element)child, (QName)this.idAttrQName), (String)"remove lookup by QName in created element");
        Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)child, (QName)this.idAttrQName), (String)"attribute lookup by QName after it has been removed");
    }

    @Test
    public void testGetAttributeMethods() {
        Assert.assertNull((Object)AttributeSupport.getAttribute((Element)this.noBaseIdSpaceLang, (QName)XMLConstants.XML_ID_ATTRIB_NAME), (String)"no xml:id (lookup by QName)");
        Attr attr = AttributeSupport.getAttribute((Element)this.goodBaseIdSpaceLang, (QName)XMLConstants.XML_ID_ATTRIB_NAME);
        Assert.assertNotNull((Object)attr, (String)"Should have found xml:id attribute");
        Assert.assertEquals((String)attr.getValue(), (String)"identifierGoodBaseIdSpaceLang", (String)"Should have found correct attribute by value for xml_id attribute");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.goodBaseIdSpaceLang, null), (String)"no xml:id (lookup value with null QName)");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue(null, (QName)XMLConstants.XML_ID_ATTRIB_NAME), (String)"no xml:id (lookup value with null element)");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.noBaseIdSpaceLang, (QName)XMLConstants.XML_ID_ATTRIB_NAME), (String)"no xml:id (lookup value by QName)");
        Assert.assertEquals((String)AttributeSupport.getAttributeValue((Element)this.goodBaseIdSpaceLang, (QName)XMLConstants.XML_ID_ATTRIB_NAME), (String)"identifierGoodBaseIdSpaceLang", (String)"Should have found correct value for xml:id attribute by QName");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.badSpace, (String)"http://www.w3.org/XML/1998/namespace", null), (String)"no value lookup with null name)");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.badSpace, (String)"http://www.w3.org/XML/1998/namespace", (String)""), (String)"no value lookup with empty name)");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue(null, (String)"http://www.w3.org/XML/1998/namespace", (String)"space"), (String)"no value lookup with null element)");
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.noBaseIdSpaceLang, (String)"http://www.w3.org/XML/1998/namespace", (String)"space"), (String)"no xml:space (lookup value by name)");
        Assert.assertEquals((String)AttributeSupport.getAttributeValue((Element)this.badSpace, (String)"http://www.w3.org/XML/1998/namespace", (String)"space"), (String)"wibble", (String)"Should have found correct value for xml:space attribute by name");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsBoolean(null), (String)"null attribute should be null");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"\" should be null");
        Assert.assertFalse((boolean)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrZero"))), (String)"0 should be false");
        Assert.assertTrue((boolean)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrOne"))), (String)"1 should be true");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrThree"))), (String)"2 should be null");
        Assert.assertFalse((boolean)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrFalse"))), (String)"false should be false");
        Assert.assertTrue((boolean)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrTrue"))), (String)"true should be true");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsBoolean((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrTrueCaps"))), (String)"TRUE should be null");
        Assert.assertTrue((boolean)AttributeSupport.getAttributeValueAsList(null).isEmpty(), (String)"null attribute should give empty list");
        Assert.assertTrue((boolean)AttributeSupport.getAttributeValueAsList((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))).isEmpty(), (String)"\"\" attribute should give empty list");
        Assert.assertEquals((Collection)AttributeSupport.getAttributeValueAsList((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrZero"))), Arrays.asList("0"), (String)"attribute called testAttrZero");
        Assert.assertEquals((Collection)AttributeSupport.getAttributeValueAsList((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrList"))), Arrays.asList("0", "1", "2", "3", "4", "5", "6"), (String)"attribute called testAttrList");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsQName(null), (String)"null attribute should be null");
        Assert.assertNull((Object)AttributeSupport.getAttributeValueAsQName((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"\" should be null");
        Assert.assertEquals((Object)AttributeSupport.getAttributeValueAsQName((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrQName"))), (Object)this.idAttrQName, (String)"attribute called testAttrQName");
        Assert.assertEquals((Object)AttributeSupport.getAttributeValueAsQName((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrZero"))), (Object)new QName("0"), (String)"attribute called testAttrZero");
        Assert.assertNull((Object)AttributeSupport.getDateTimeAttribute(null), (String)"null attribute should be null");
        Assert.assertNull((Object)AttributeSupport.getDateTimeAttribute((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"\" should be null");
        Assert.assertNull((Object)AttributeSupport.getDateTimeAttribute((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"0\" should be null");
        Assert.assertEquals((Object)AttributeSupport.getDateTimeAttribute((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEpochPlusOneSec"))), (Object)Instant.ofEpochSecond(1L), (String)"attribute called testAttrEpochPlusOneSec");
        Assert.assertNull((Object)AttributeSupport.getDurationAttributeValue(null), (String)"null attribute should be null");
        Assert.assertNull((Object)AttributeSupport.getDurationAttributeValue((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"\" should be null");
        Assert.assertNull((Object)AttributeSupport.getDurationAttributeValue((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrEmpty"))), (String)"\"0\" should be null");
        Assert.assertEquals((Object)AttributeSupport.getDurationAttributeValue((Attr)AttributeSupport.getAttribute((Element)this.attributes, (QName)new QName(TEST_NS, "testAttrMinusOneDay"))), (Object)Duration.ofDays(-1L), (String)"attribute called testAttrMinusOneDay");
    }

    @Test(dependsOnMethods={"testGetAttributeMethods", "testGetID"})
    public void testAppends() {
        Object qNameBase = "name";
        Object testResult = TEST_ID_ATTRIBUTE_VALUE;
        QName qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        boolean thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)((Element)this.nullValue()), (QName)qName, (String)testResult);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)((QName)this.nullValue()), (String)testResult);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null qname should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (String)((String)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (String)testResult);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"All non nulls should not throw");
        Assert.assertEquals((String)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)testResult, (String)"appendAttribute(Element, QName, String) failed");
        qNameBase = (String)qNameBase + "New";
        testResult = (String)testResult + "New";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Test precondition");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)((Element)this.nullValue()), (QName)qName, (String)testResult, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)((QName)this.nullValue()), (String)testResult, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null qname should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (String)((String)this.nullValue()), (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (String)testResult, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"All non nulls should not throw");
        Assert.assertEquals((String)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)testResult, (String)"appendAttribute(Element, QName, String) failed");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Should not have added an id Attribute");
        qNameBase = (String)qNameBase + "New";
        testResult = (String)testResult + "New";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Test precondition");
        AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (String)testResult, (boolean)true);
        Assert.assertEquals((String)AttributeSupport.getIdAttribute((Element)this.createdElement).getValue(), (String)testResult, (String)"id Attribute added correctly");
        AttributeSupport.removeAttribute((Element)this.createdElement, (QName)qName);
        qNameBase = (String)qNameBase + "New";
        List<String> data = Arrays.asList("one", "2", "iii");
        testResult = "one 2 iii";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Test precondition");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)((Element)this.nullValue()), (QName)qName, data, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)((QName)this.nullValue()), data, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null qname should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, (List)null, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null string should throw");
        thrown = false;
        try {
            AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, data, (boolean)false);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"All non nulls should not throw");
        Assert.assertEquals((String)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)testResult, (String)"appendAttribute(Element, QName, String) failed");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Should not have added an id Attribute");
        qNameBase = (String)qNameBase + "New";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        Assert.assertNull((Object)AttributeSupport.getIdAttribute((Element)this.createdElement), (String)"Test precondition");
        AttributeSupport.appendAttribute((Element)this.createdElement, (QName)qName, data, (boolean)true);
        Assert.assertEquals((String)AttributeSupport.getIdAttribute((Element)this.createdElement).getValue(), (String)testResult, (String)"id Attribute added correctly");
        Duration duration = Duration.ofSeconds(1L);
        qNameBase = (String)qNameBase + "New";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        thrown = false;
        try {
            AttributeSupport.appendDurationAttribute((Element)((Element)this.nullValue()), (QName)qName, (Duration)duration);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element should throw");
        thrown = false;
        try {
            AttributeSupport.appendDurationAttribute((Element)this.createdElement, (QName)((QName)this.nullValue()), (Duration)duration);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null qname should throw");
        thrown = false;
        try {
            AttributeSupport.appendDurationAttribute((Element)this.createdElement, (QName)qName, (Duration)duration);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"All non nulls should not throw");
        Assert.assertEquals((Object)AttributeSupport.getDurationAttributeValue((Attr)AttributeSupport.getAttribute((Element)this.createdElement, (QName)qName)), (Object)duration, (String)"getDurationAttributeValueAsLong failed");
        Instant time = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        qNameBase = (String)qNameBase + "New";
        qName = new QName(TEST_NS, (String)qNameBase, TEST_PREFIX);
        Assert.assertNull((Object)AttributeSupport.getAttributeValue((Element)this.createdElement, (QName)qName), (String)"Test precondition");
        thrown = false;
        try {
            AttributeSupport.appendDateTimeAttribute((Element)((Element)this.nullValue()), (QName)qName, (Instant)time);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null element should throw");
        thrown = false;
        try {
            AttributeSupport.appendDateTimeAttribute((Element)this.createdElement, (QName)((QName)this.nullValue()), (Instant)time);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"null qname should throw");
        thrown = false;
        try {
            AttributeSupport.appendDateTimeAttribute((Element)this.createdElement, (QName)qName, (Instant)time);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"All non nulls should not throw");
        Assert.assertEquals((Object)AttributeSupport.getDateTimeAttribute((Attr)AttributeSupport.getAttribute((Element)this.createdElement, (QName)qName)), (Object)time, (String)"getDurationAttributeValueAsLong failed");
    }

    @Test
    public void testQNameContent() throws XMLParserException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        Document doc = builder.newDocument();
        Attr attr = doc.createAttributeNS("https://example", "foo");
        attr.setNodeValue("foo");
        QName qname = AttributeSupport.getAttributeValueAsQName((Attr)attr);
        Assert.assertEquals((String)qname.getLocalPart(), (String)"foo");
        Assert.assertEquals((String)qname.getNamespaceURI(), (String)"");
        Assert.assertEquals((String)qname.getPrefix(), (String)"");
        attr.setNodeValue("bar:foo");
        qname = AttributeSupport.getAttributeValueAsQName((Attr)attr);
        Assert.assertEquals((String)qname.getLocalPart(), (String)"foo");
        Assert.assertEquals((String)qname.getNamespaceURI(), (String)"");
        Assert.assertEquals((String)qname.getPrefix(), (String)"bar");
        attr.setNodeValue("bar:foo:baz");
        try {
            qname = AttributeSupport.getAttributeValueAsQName((Attr)attr);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private <T> T nullValue() {
        return null;
    }
}

