/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class EvaluableScriptTest {
    @Nonnull
    @NotEmpty
    private static final String SCRIPT_LANGUAGE = "JavaScript";
    @Nonnull
    @NotEmpty
    private static final String TEST_SIMPLE_SCRIPT = "importPackage(Packages.net.shibboleth.idp.attribute);\nfoo = res = new Attribute(\"bar\");\n foo.addValue(\"value\");\n";
    private File theFile;

    @AfterClass
    public void deleteFile() {
        if (null != this.theFile && this.theFile.exists()) {
            this.theFile.delete();
        }
    }

    @Test
    public void testEvaluableScriptDeprecated() throws ScriptException, IOException {
        new EvaluableScript(SCRIPT_LANGUAGE, TEST_SIMPLE_SCRIPT);
        try {
            new EvaluableScript(" ", TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, " ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript((String)this.nullValue(), TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, (String)this.nullValue());
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        this.theFile = File.createTempFile("EvaluableScriptTest", ".js");
        try (FileWriter s = new FileWriter(this.theFile);){
            s.write(TEST_SIMPLE_SCRIPT, 0, TEST_SIMPLE_SCRIPT.length());
        }
        Assert.assertEquals((String)new EvaluableScript(SCRIPT_LANGUAGE, this.theFile).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        try (FileInputStream is = new FileInputStream(this.theFile);){
            Assert.assertEquals((String)new EvaluableScript(SCRIPT_LANGUAGE, (InputStream)is).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        }
        is = new FileInputStream(this.theFile);
        try {
            Assert.assertEquals((String)new EvaluableScript(SCRIPT_LANGUAGE, this.resourceFor(is)).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        }
        finally {
            ((InputStream)is).close();
        }
        try {
            new EvaluableScript((String)this.nullValue(), this.theFile);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, (File)this.nullValue());
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private EvaluableScript testEvaluableScript(String language, String script) throws ComponentInitializationException {
        EvaluableScript ev = new EvaluableScript();
        ev.setEngineName(language);
        ev.setScript(script);
        ev.initialize();
        return ev;
    }

    private EvaluableScript testEvaluableScript(String language, File script) throws ComponentInitializationException, IOException {
        EvaluableScript ev = new EvaluableScript();
        ev.setEngineName(language);
        ev.setScript(script);
        ev.initialize();
        return ev;
    }

    private EvaluableScript testEvaluableScript(String language, InputStream script) throws ComponentInitializationException, IOException {
        EvaluableScript ev = new EvaluableScript();
        ev.setEngineName(language);
        ev.setScript(script);
        ev.initialize();
        return ev;
    }

    private EvaluableScript testEvaluableScript(String language, Resource script) throws ComponentInitializationException, IOException {
        EvaluableScript ev = new EvaluableScript();
        ev.setEngineName(language);
        ev.setScript(script);
        ev.initialize();
        return ev;
    }

    @Test
    public void testEvaluableScriptNonDeprecated() throws ScriptException, IOException, ComponentInitializationException {
        this.testEvaluableScript(SCRIPT_LANGUAGE, TEST_SIMPLE_SCRIPT);
        try {
            this.testEvaluableScript(" ", TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.testEvaluableScript(SCRIPT_LANGUAGE, " ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.testEvaluableScript((String)this.nullValue(), TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.testEvaluableScript(SCRIPT_LANGUAGE, (String)this.nullValue());
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        this.theFile = File.createTempFile("EvaluableScriptTest", ".js");
        try (FileWriter s = new FileWriter(this.theFile);){
            s.write(TEST_SIMPLE_SCRIPT, 0, TEST_SIMPLE_SCRIPT.length());
        }
        Assert.assertEquals((String)this.testEvaluableScript(SCRIPT_LANGUAGE, this.theFile).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        try (FileInputStream is = new FileInputStream(this.theFile);){
            Assert.assertEquals((String)this.testEvaluableScript(SCRIPT_LANGUAGE, is).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        }
        is = new FileInputStream(this.theFile);
        try {
            Assert.assertEquals((String)this.testEvaluableScript(SCRIPT_LANGUAGE, this.resourceFor(is)).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        }
        finally {
            ((InputStream)is).close();
        }
        try {
            this.testEvaluableScript((String)this.nullValue(), this.theFile);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            this.testEvaluableScript(SCRIPT_LANGUAGE, (File)this.nullValue());
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private Resource resourceFor(final InputStream is) {
        return new Resource(){

            public long lastModified() throws IOException {
                return 0L;
            }

            public boolean isReadable() {
                return true;
            }

            public boolean isOpen() {
                return false;
            }

            public URL getURL() throws IOException {
                return null;
            }

            public URI getURI() throws IOException {
                return null;
            }

            public InputStream getInputStream() throws IOException {
                return is;
            }

            public String getFilename() {
                return null;
            }

            public File getFile() throws IOException {
                return null;
            }

            public String getDescription() {
                return null;
            }

            public boolean exists() {
                return true;
            }

            public Resource createRelativeResource(String relativePath) throws IOException {
                return null;
            }

            public long contentLength() throws IOException {
                return 0L;
            }
        };
    }

    private <T> T nullValue() {
        return null;
    }
}

