/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.time.Duration;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.httpclient.IdleConnectionSweeper;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IdleConectionSweeperTest {
    private final Duration SWEEP_INTERVAL = Duration.ofMillis(50L);

    @Test
    public void test() throws Exception {
        MyCm connectionManager = new MyCm();
        IdleConnectionSweeper sweeper = new IdleConnectionSweeper((HttpClientConnectionManager)connectionManager, Duration.ofMillis(30L), this.SWEEP_INTERVAL);
        Thread.yield();
        if (!connectionManager.isCloseCalled()) {
            Thread.sleep(25L + this.SWEEP_INTERVAL.toMillis());
            Thread.yield();
            if (!connectionManager.isCloseCalled()) {
                Thread.sleep(25L + this.SWEEP_INTERVAL.toMillis());
                Thread.yield();
                Assert.assertTrue((boolean)connectionManager.isCloseCalled());
            }
        }
        sweeper.destroy();
        Assert.assertTrue((boolean)sweeper.isDestroyed());
        try {
            sweeper.scheduledExecutionTime();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        connectionManager = new MyCm();
        Timer timer = new Timer(true);
        sweeper = new IdleConnectionSweeper((HttpClientConnectionManager)connectionManager, Duration.ofMillis(30L), this.SWEEP_INTERVAL, timer);
        Thread.yield();
        if (!connectionManager.isCloseCalled()) {
            Thread.sleep(this.SWEEP_INTERVAL.toMillis());
            Thread.yield();
            int loopCount = 0;
            while (!connectionManager.isCloseCalled()) {
                Thread.sleep(this.SWEEP_INTERVAL.toMillis());
                Thread.yield();
                Assert.assertTrue((++loopCount != 5 ? 1 : 0) != 0);
            }
        }
        sweeper.destroy();
        Assert.assertTrue((boolean)sweeper.isDestroyed());
        try {
            sweeper.scheduledExecutionTime();
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        timer.cancel();
    }

    private class MyCm
    extends PoolingHttpClientConnectionManager {
        private boolean closeCalled;

        private MyCm() {
        }

        public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
            this.closeCalled = true;
            super.closeIdleConnections(idletime, timeUnit);
        }

        public boolean isCloseCalled() {
            return this.closeCalled;
        }
    }
}

