/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.Arrays;
import java.util.Map;
import net.shibboleth.utilities.java.support.collection.ValueTypeIndexedMap;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValueTypeIndexedMapTest {
    private ValueTypeIndexedMap<String, Object> map;

    @BeforeMethod
    public void setUp() {
        this.map = new ValueTypeIndexedMap();
        this.map.setTypes(Arrays.asList(Integer.class, String.class));
        this.map.rebuildIndex();
    }

    @Test
    public void testBasic() {
        this.map.put((Object)"i1", (Object)Integer.parseInt("4"));
        this.map.put((Object)"s1", (Object)"first string");
        this.map.put((Object)"s2", (Object)"second string");
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)2);
        this.map.remove((Object)"s1");
        Assert.assertEquals((int)this.map.size(), (int)2);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)1);
    }

    @Test
    public void testNullKeys() {
        this.map.put((Object)"i1", (Object)Integer.parseInt("2"));
        this.map.put(null, (Object)Integer.parseInt("3"));
        this.map.put((Object)"s1", (Object)"first string");
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)2);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)1);
        this.map.put(null, (Object)"new string");
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)2);
        Assert.assertTrue((boolean)this.map.containsKey(null));
        this.map.remove(null);
        Assert.assertFalse((boolean)this.map.containsKey(null));
    }

    @Test
    public void testNullValues() {
        this.map.getTypes().add(null);
        this.map.rebuildIndex();
        this.map.put((Object)"i1", (Object)Integer.parseInt("3"));
        this.map.put((Object)"n1", null);
        this.map.put((Object)"s1", (Object)"first string");
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(null).size(), (int)1);
        this.map.put((Object)"i1", (Object)"new string");
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)0);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)2);
        Assert.assertEquals((int)this.map.subMap(null).size(), (int)1);
        this.map.put((Object)"i1", null);
        Assert.assertEquals((int)this.map.size(), (int)3);
        Assert.assertEquals((int)this.map.subMap(Integer.class).size(), (int)0);
        Assert.assertEquals((int)this.map.subMap(String.class).size(), (int)1);
        Assert.assertEquals((int)this.map.subMap(null).size(), (int)2);
    }

    @Test
    public void testEqualsHashCode() {
        ValueTypeIndexedMap other = new ValueTypeIndexedMap();
        other.setTypes(Arrays.asList(Integer.class));
        other.rebuildIndex();
        Assert.assertEquals(this.map, (Map)other, (String)"Empty maps should be the same");
        Assert.assertEquals((int)this.map.hashCode(), (int)other.hashCode(), (String)"Empty maps have same hash code");
        this.map.put((Object)"i1", (Object)Integer.parseInt("4"));
        this.map.put((Object)"s1", (Object)"first string");
        this.map.put((Object)"s2", (Object)"second string");
        other.put((Object)"i1", (Object)Integer.parseInt("4"));
        Assert.assertNotSame(this.map, (Object)other, (String)"Different maps should differ");
        Assert.assertNotSame((Object)this.map.hashCode(), (Object)other.hashCode(), (String)"Different maps should have different hash codes");
        this.map.remove((Object)"s1");
        other.put((Object)"s2", (Object)"second string");
        Assert.assertEquals(this.map, (Map)other, (String)"Similar maps should be equals");
        Assert.assertEquals((int)this.map.hashCode(), (int)other.hashCode(), (String)"Similar maps should have the same hash codes");
    }
}

