/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElementSupportTest {
    @Nonnull
    @NotEmpty
    private static final String TEST_NS = "http://example.org/NameSpace";
    @Nonnull
    @NotEmpty
    private static final String OTHER_NS = "http://example.org/OtherSpace";
    @Nonnull
    @NotEmpty
    private static final String TEST_PREFIX = "testns";
    @Nonnull
    @NotEmpty
    private static final String TEST_ELEMENT_NAME = "Element1";
    @Nonnull
    @NotEmpty
    private static final String ROOT_ELEMENT = "Container";
    @Nonnull
    private static final QName TEST_ELEMENT_QNAME = new QName("http://example.org/NameSpace", "Element1", "testns");
    private BasicParserPool parserPool;
    private Document testFileDocument;
    private Document testerDocument;
    private Element rootElement;

    @BeforeClass
    public void setUp() throws XMLParserException, ComponentInitializationException, SAXException, IOException {
        this.parserPool = new BasicParserPool();
        this.parserPool.setCoalescing(false);
        this.parserPool.initialize();
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/elementSupportTest.xml");
            this.testFileDocument = builder.parse(resource.getInputStream());
            this.rootElement = (Element)this.testFileDocument.getFirstChild();
            this.testerDocument = builder.newDocument();
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testIsElementNamed() {
        Assert.assertFalse((boolean)ElementSupport.isElementNamed(null, (String)TEST_NS, (String)ROOT_ELEMENT), (String)"not find if provided element is null");
        Assert.assertFalse((boolean)ElementSupport.isElementNamed((Element)this.rootElement, null, (String)ROOT_ELEMENT), (String)"not find if provided namespace is null");
        Assert.assertFalse((boolean)ElementSupport.isElementNamed((Element)this.rootElement, (String)TEST_NS, null), (String)"not find if provided attribute name is null");
        Assert.assertFalse((boolean)ElementSupport.isElementNamed((Element)this.rootElement, null), (String)"not find if provided attribute QName is null");
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)this.rootElement, (QName)new QName(TEST_NS, ROOT_ELEMENT, TEST_PREFIX)), (String)"lookup against QNAME");
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)this.rootElement, (String)TEST_NS, (String)ROOT_ELEMENT), (String)"lookup against name");
        Assert.assertFalse((boolean)ElementSupport.isElementNamed((Element)this.rootElement, (String)TEST_NS, (String)ROOT_ELEMENT.toUpperCase()), (String)"lookup against upper of name");
        Assert.assertFalse((boolean)ElementSupport.isElementNamed((Element)this.rootElement, (String)TEST_NS.toUpperCase(), (String)ROOT_ELEMENT), (String)"lookup against upper of namespace");
    }

    @Test(dependsOnMethods={"testIsElementNamed"})
    public void testGetChildElements() {
        Assert.assertTrue((boolean)ElementSupport.getChildElements(null).isEmpty(), (String)"Null should provide empty list");
        Assert.assertTrue((boolean)ElementSupport.getChildElements((Node)this.rootElement, null).isEmpty(), (String)"Null QName should provide empty list");
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)this.rootElement).size(), (int)8, (String)"unnanmed element lookup");
        List list = ElementSupport.getChildElements((Node)this.rootElement, (QName)TEST_ELEMENT_QNAME);
        Assert.assertEquals((int)list.size(), (int)3, (String)"Named element lookup");
        for (Element e : list) {
            Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)e, (QName)TEST_ELEMENT_QNAME));
        }
    }

    @Test(dependsOnMethods={"testIsElementNamed"})
    public void testGetChildElementsByTagName() {
        Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagName((Node)this.rootElement, null).isEmpty(), (String)"getChildElementsByTagName: Null name should provide empty list");
        Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagName(null, (String)TEST_ELEMENT_NAME).isEmpty(), (String)"getChildElementsByTagName: Null root  should provide empty list");
        Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)this.rootElement, (String)TEST_NS, null).isEmpty(), (String)"getChildElementsByTagName: Null name should provide empty list");
        Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)this.rootElement, null, (String)TEST_ELEMENT_NAME).isEmpty(), (String)"getChildElementsByTagNameNS: Null name space should provide empty list");
        Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS(null, (String)TEST_NS, (String)TEST_ELEMENT_NAME).isEmpty(), (String)"getChildElementsByTagNameNS: Null root  should provide empty list");
        List list = ElementSupport.getChildElementsByTagName((Node)this.rootElement, (String)TEST_ELEMENT_NAME);
        Assert.assertEquals((int)list.size(), (int)5, (String)"getChildElementsByTagName size");
        int i = 0;
        for (Element e : list) {
            if (!ElementSupport.isElementNamed((Element)e, (QName)TEST_ELEMENT_QNAME)) continue;
            ++i;
        }
        Assert.assertEquals((int)i, (int)3, (String)"getChildElementsByTagName size");
        list = ElementSupport.getChildElementsByTagNameNS((Node)this.rootElement, (String)TEST_NS, (String)TEST_ELEMENT_NAME);
        Assert.assertEquals((int)list.size(), (int)3, (String)"getChildElementsByTagName size");
        for (Element e : list) {
            Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)e, (QName)TEST_ELEMENT_QNAME));
        }
    }

    @Test(dependsOnMethods={"testGetChildElementsByTagName"})
    public void testGetElementAncestor() {
        Assert.assertNull((Object)ElementSupport.getElementAncestor(null), (String)"getElementAncestor: Null element should provide null result");
        Assert.assertNull((Object)ElementSupport.getElementAncestor((Node)this.rootElement), (String)"getElementAncestor: root node should provide null result");
        Element child = (Element)ElementSupport.getChildElementsByTagName((Node)this.rootElement, (String)"Element4").get(0);
        Element grandChild = (Element)ElementSupport.getChildElementsByTagName((Node)child, (String)TEST_ELEMENT_NAME).get(0);
        Assert.assertEquals((Object)ElementSupport.getElementAncestor((Node)child), (Object)this.rootElement, (String)"getElementAncestor for child");
        Assert.assertEquals((Object)ElementSupport.getElementAncestor((Node)grandChild), (Object)child, (String)"getElementAncestor for grand child");
    }

    @Test(dependsOnMethods={"testGetChildElementsByTagName"})
    public void testGetElementContentAsString() {
        Assert.assertTrue((boolean)ElementSupport.getElementContentAsString(null).isEmpty(), (String)"getElementContentAsList: Null element should provide empty result");
        Assert.assertTrue((boolean)StringSupport.trim((String)ElementSupport.getElementContentAsString((Element)this.rootElement)).isEmpty(), (String)"getElementContentAsList: Empty element should provide empty result");
        Element interesting = (Element)ElementSupport.getChildElementsByTagName((Node)((Node)ElementSupport.getChildElementsByTagName((Node)this.rootElement, (String)"Element4").get(0)), (String)TEST_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)ElementSupport.getElementContentAsString((Element)interesting), (String)"Some Random foo\ntest");
    }

    @Test(dependsOnMethods={"testGetChildElementsByTagName"})
    public void testGetElementContentAsList() {
        Assert.assertTrue((boolean)ElementSupport.getElementContentAsList(null).isEmpty(), (String)"getElementContentAsList: Null element should provide empty result");
        Assert.assertTrue((boolean)ElementSupport.getElementContentAsList((Element)this.rootElement).isEmpty(), (String)"getElementContentAsList: Empty element should provide empty result");
        Element interesting = (Element)ElementSupport.getChildElementsByTagName((Node)((Node)ElementSupport.getChildElementsByTagName((Node)this.rootElement, (String)"Element4").get(0)), (String)TEST_ELEMENT_NAME).get(0);
        Assert.assertEquals((Collection)ElementSupport.getElementContentAsList((Element)interesting), Arrays.asList("Some", "Random", "foo", "test"));
    }

    @Test(dependsOnMethods={"testGetChildElementsByTagName"})
    public void testGetElementContentAsQName() {
        Assert.assertNull((Object)ElementSupport.getElementContentAsQName(null), (String)"getElementContentAsQName: Null element should provide empty result");
        Assert.assertNull((Object)ElementSupport.getElementContentAsQName((Element)this.rootElement), (String)"getElementContentAsQName: Empty element should provide empty result");
        Element parent = (Element)ElementSupport.getChildElementsByTagName((Node)this.rootElement, (String)"Element4").get(0);
        List children = ElementSupport.getChildElementsByTagName((Node)parent, (String)"QName");
        Assert.assertEquals((Object)ElementSupport.getElementContentAsQName((Element)((Element)children.get(0))), (Object)new QName(OTHER_NS, "localname"));
        Assert.assertNull((Object)ElementSupport.getElementContentAsQName((Element)((Element)children.get(1))), (String)"getElementContentAsQName: invalid qname should return null");
    }

    @Test(dependsOnMethods={"testIsElementNamed"})
    public void testGetChildAndNext() {
        Assert.assertNull((Object)ElementSupport.getFirstChildElement(null), (String)"getFirstChildElement: Null element should provide null result");
        Assert.assertNull((Object)ElementSupport.getNextSiblingElement(null), (String)"getNextSiblingElement: Null element should provide null result");
        Element element = ElementSupport.getFirstChildElement((Node)this.rootElement);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)TEST_ELEMENT_QNAME), (String)"getFirstChildElement");
        Assert.assertNull((Object)ElementSupport.getFirstChildElement((Node)element), (String)"getFirstChildElement: Empty element should provide null result");
        element = ElementSupport.getNextSiblingElement((Node)element);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)TEST_ELEMENT_QNAME), (String)"getNextSiblingElement 1");
        element = ElementSupport.getNextSiblingElement((Node)element);
        QName qName = new QName(TEST_NS, "Element2", TEST_PREFIX);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 2");
        element = ElementSupport.getNextSiblingElement((Node)element);
        qName = new QName(TEST_NS, TEST_ELEMENT_NAME, "mynsagain");
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 3");
        element = ElementSupport.getNextSiblingElement((Node)element);
        qName = new QName(OTHER_NS, TEST_ELEMENT_NAME, TEST_PREFIX);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 4 ");
        element = ElementSupport.getNextSiblingElement((Node)element);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 5");
        element = ElementSupport.getNextSiblingElement((Node)element);
        qName = new QName(OTHER_NS, "Element2", TEST_PREFIX);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 6");
        element = ElementSupport.getNextSiblingElement((Node)element);
        qName = new QName(TEST_NS, "Element4", TEST_PREFIX);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)element, (QName)qName), (String)"getNextSiblingElement 7");
        Assert.assertNull((Object)ElementSupport.getNextSiblingElement((Node)element), (String)"getNextSiblingElement: final element should provide null result");
    }

    @Test
    public void testGetIndexedChildElements() {
        Assert.assertTrue((boolean)ElementSupport.getIndexedChildElements(null).isEmpty(), (String)"getIndexedChildElements with null input");
        Map map = ElementSupport.getIndexedChildElements((Element)this.rootElement);
        Assert.assertEquals((int)((List)map.get(TEST_ELEMENT_QNAME)).size(), (int)3, (String)("getIndexedChildElements for " + TEST_ELEMENT_QNAME));
        map.remove(TEST_ELEMENT_QNAME);
        QName qname = new QName(TEST_NS, "Element2", TEST_PREFIX);
        Assert.assertEquals((int)((List)map.get(qname)).size(), (int)1, (String)("getIndexedChildElements for " + qname));
        map.remove(qname);
        qname = new QName(OTHER_NS, TEST_ELEMENT_NAME, "otherns");
        Assert.assertEquals((int)((List)map.get(qname)).size(), (int)2, (String)("getIndexedChildElements for " + qname));
        map.remove(qname);
        qname = new QName(OTHER_NS, "Element2", "otherns");
        Assert.assertEquals((int)((List)map.get(qname)).size(), (int)1, (String)("getIndexedChildElements for " + qname));
        Element elementNoKids = (Element)((List)map.get(qname)).get(0);
        map.remove(qname);
        qname = new QName(TEST_NS, "Element4", TEST_PREFIX);
        Assert.assertEquals((int)((List)map.get(qname)).size(), (int)1, (String)("getIndexedChildElements for " + qname));
        map.remove(qname);
        Assert.assertTrue((boolean)map.isEmpty(), (String)"getIndexedChildElements found extra elements");
        Assert.assertTrue((boolean)ElementSupport.getIndexedChildElements((Element)elementNoKids).isEmpty(), (String)"getIndexedChildElements with a no child element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testConstructElement"})
    public void testAdoptElement() throws XMLParserException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            Document otherDocument = builder.newDocument();
            Element element = ElementSupport.constructElement((Document)this.testerDocument, (QName)TEST_ELEMENT_QNAME);
            this.testerDocument.appendChild(element);
            boolean thrown = false;
            try {
                ElementSupport.adoptElement((Document)((Document)this.nullValue()), (Element)element);
            }
            catch (ConstraintViolationException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown, (String)"adoptElement: Null Document should assert");
            thrown = false;
            try {
                ElementSupport.adoptElement((Document)this.testerDocument, (Element)((Element)this.nullValue()));
            }
            catch (ConstraintViolationException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown, (String)"adoptElement: Null Element should assert");
            Assert.assertNotSame((Object)element.getOwnerDocument(), (Object)otherDocument, (String)"Initially: element not owned");
            Assert.assertEquals((Object)element.getOwnerDocument(), (Object)this.testerDocument, (String)"Initially: element owned");
            ElementSupport.adoptElement((Document)this.testerDocument, (Element)element);
            Assert.assertNotSame((Object)element.getOwnerDocument(), (Object)otherDocument, (String)"ReAdopt: element not owned");
            Assert.assertEquals((Object)element.getOwnerDocument(), (Object)this.testerDocument, (String)"ReAdopt: element owned");
            ElementSupport.adoptElement((Document)otherDocument, (Element)element);
            Assert.assertEquals((Object)element.getOwnerDocument(), (Object)otherDocument, (String)"After: element owned");
            Assert.assertNotSame((Object)element.getOwnerDocument(), (Object)this.testerDocument, (String)"After:  new element not owned");
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testConstructElement", "testGetChildElements", "testGetChildElementsByTagName"})
    public void testAppendChildElement() throws XMLParserException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            Document myDocument = builder.newDocument();
            Element myRoot = ElementSupport.constructElement((Document)this.testerDocument, (QName)new QName(TEST_NS, ROOT_ELEMENT, TEST_PREFIX));
            Element testElement = ElementSupport.constructElement((Document)this.testerDocument, (QName)TEST_ELEMENT_QNAME);
            boolean thrown = false;
            try {
                ElementSupport.appendChildElement((Element)((Element)this.nullValue()), (Element)testElement);
            }
            catch (ConstraintViolationException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown, (String)"appendChildElement: assert on null parent");
            Assert.assertTrue((boolean)ElementSupport.getChildElements((Node)myRoot).isEmpty(), (String)"appendChildElement: no elements to start with");
            ElementSupport.appendChildElement((Element)myRoot, (Element)testElement);
            Assert.assertEquals((int)ElementSupport.getChildElements((Node)myRoot).size(), (int)1, (String)"appendChildElement: One elements after one insertion");
            ElementSupport.appendChildElement((Element)myRoot, (Element)testElement);
            Assert.assertEquals((int)ElementSupport.getChildElements((Node)myRoot).size(), (int)1, (String)"appendChildElement: One elements after re insertion");
            QName qName = new QName(OTHER_NS, TEST_ELEMENT_NAME);
            ElementSupport.appendChildElement((Element)myRoot, (Element)ElementSupport.constructElement((Document)myDocument, (QName)TEST_ELEMENT_QNAME));
            ElementSupport.appendChildElement((Element)myRoot, (Element)ElementSupport.constructElement((Document)myDocument, (QName)qName));
            ElementSupport.appendChildElement((Element)myRoot, (Element)ElementSupport.constructElement((Document)myDocument, (QName)TEST_ELEMENT_QNAME));
            ElementSupport.appendChildElement((Element)myRoot, (Element)ElementSupport.constructElement((Document)myDocument, (QName)qName));
            Assert.assertEquals((int)ElementSupport.getChildElements((Node)myRoot).size(), (int)5, (String)"appendChildElement:  elements after insertion");
            Assert.assertEquals((int)ElementSupport.getChildElementsByTagNameNS((Node)myRoot, (String)TEST_NS, (String)TEST_ELEMENT_NAME).size(), (int)3, (String)"appendChildElement:  elements after insertion");
            Assert.assertEquals((int)ElementSupport.getChildElementsByTagNameNS((Node)myRoot, (String)OTHER_NS, (String)TEST_ELEMENT_NAME).size(), (int)2, (String)"appendChildElement:  elements after insertion");
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test(dependsOnMethods={"testConstructElement"})
    public void testAppendChildText() {
        Element element = ElementSupport.constructElement((Document)this.testerDocument, (QName)TEST_ELEMENT_QNAME);
        Assert.assertNull((Object)StringSupport.trimOrNull((String)element.getTextContent()), (String)"appendTextContent: initially element has no text");
        boolean thrown = false;
        try {
            ElementSupport.appendTextContent((Element)((Element)this.nullValue()), (String)"test");
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"appendTextContent: null element should assert");
        ElementSupport.appendTextContent((Element)element, null);
        Assert.assertNull((Object)StringSupport.trimOrNull((String)element.getTextContent()), (String)"appendTextContent: After null assert element has no text");
        ElementSupport.appendTextContent((Element)element, (String)"");
        Assert.assertEquals((int)element.getTextContent().length(), (int)0, (String)"appendTextContent: contents match even when empty");
        ElementSupport.appendTextContent((Element)element, (String)" test Text");
        Assert.assertEquals((String)element.getTextContent(), (String)" test Text", (String)"appendTextContent: contents match");
        ElementSupport.appendTextContent((Element)element, (String)" more Text");
        Assert.assertEquals((String)element.getTextContent(), (String)" test Text more Text", (String)"appendTextContent: contents after second append");
    }

    @Test(dependsOnMethods={"testGetChildElementsByTagName"})
    public void testConstructElement() throws XMLParserException {
        Element e = ElementSupport.constructElement((Document)this.testerDocument, (QName)TEST_ELEMENT_QNAME);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)e, (QName)TEST_ELEMENT_QNAME));
        e = ElementSupport.constructElement((Document)this.testerDocument, (String)TEST_NS, (String)TEST_ELEMENT_NAME, (String)TEST_PREFIX);
        Assert.assertTrue((boolean)ElementSupport.isElementNamed((Element)e, (QName)TEST_ELEMENT_QNAME));
    }

    @Test
    public void testConstructElementBadParms() throws XMLParserException {
        boolean thrown = false;
        try {
            ElementSupport.constructElement((Document)((Document)this.nullValue()), (QName)TEST_ELEMENT_QNAME);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"constructElement(Document, QName): null Document should throw");
        thrown = false;
        try {
            ElementSupport.constructElement((Document)this.testerDocument, (QName)((QName)this.nullValue()));
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"constructElement(Document, QName): null QName should throw");
        thrown = false;
        try {
            ElementSupport.constructElement((Document)this.testerDocument, (String)TEST_NS, (String)((String)this.nullValue()), (String)TEST_PREFIX);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"constructElement(Document, String, String, String): null ElementName should throw");
        thrown = false;
        try {
            ElementSupport.constructElement((Document)((Document)this.nullValue()), (String)TEST_NS, (String)TEST_ELEMENT_NAME, (String)TEST_PREFIX);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"constructElement(Document, String, String, String): null ElementName should throw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testConstructElement", "testGetChildElements"})
    public void testSetDocumentElement() throws XMLParserException {
        DocumentBuilder builder = this.parserPool.getBuilder();
        try {
            Document myDocument = builder.newDocument();
            Element myRoot = ElementSupport.constructElement((Document)this.testerDocument, (QName)new QName(TEST_NS, ROOT_ELEMENT, TEST_PREFIX));
            boolean thrown = false;
            try {
                ElementSupport.setDocumentElement((Document)myDocument, (Element)((Element)this.nullValue()));
            }
            catch (ConstraintViolationException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown, (String)"setDocumentElement: null Element should assert");
            thrown = false;
            try {
                ElementSupport.setDocumentElement((Document)((Document)this.nullValue()), (Element)myRoot);
            }
            catch (ConstraintViolationException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown, (String)"setDocumentElement: null Document should assert");
            Assert.assertTrue((boolean)ElementSupport.getChildElements((Node)myDocument).isEmpty(), (String)"New document should be empty");
            ElementSupport.setDocumentElement((Document)myDocument, (Element)myRoot);
            List list = ElementSupport.getChildElements((Node)myDocument);
            Assert.assertEquals((int)list.size(), (int)1, (String)"setDocumentElement: One child after element set");
            Assert.assertEquals(list.get(0), (Object)myRoot, (String)"setDocumentElement: after element set");
            ElementSupport.setDocumentElement((Document)myDocument, (Element)myRoot);
            list = ElementSupport.getChildElements((Node)myDocument);
            Assert.assertEquals((int)list.size(), (int)1, (String)"setDocumentElement: One child after element re-set");
            Assert.assertEquals(list.get(0), (Object)myRoot, (String)"setDocumentElement: after element re-set");
            Element otherRoot = ElementSupport.constructElement((Document)this.testerDocument, (QName)new QName(TEST_NS, ROOT_ELEMENT, TEST_PREFIX));
            ElementSupport.setDocumentElement((Document)myDocument, (Element)otherRoot);
            list = ElementSupport.getChildElements((Node)myDocument);
            Assert.assertEquals((int)list.size(), (int)1, (String)"setDocumentElement: One child after element re-set");
            Assert.assertEquals(list.get(0), (Object)otherRoot, (String)"setDocumentElement: after element re-set");
        }
        finally {
            this.parserPool.returnBuilder(builder);
        }
    }

    private <T> T nullValue() {
        return null;
    }
}

