/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resolver;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.CriterionPredicateRegistry;
import net.shibboleth.utilities.java.support.resolver.EvaluableFooCriterion;
import net.shibboleth.utilities.java.support.resolver.EvaluableTestFooCriterion;
import net.shibboleth.utilities.java.support.resolver.Foo;
import net.shibboleth.utilities.java.support.resolver.FooPredicate;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.resolver.ResolverSupport;
import net.shibboleth.utilities.java.support.resolver.TestCriterion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResolverSupportTest {
    @Test
    public void testGetPredicates() throws ResolverException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        registry.register(TestCriterion.class, FooPredicate.class);
        EvaluableTestFooCriterion evaluableCriterion = new EvaluableTestFooCriterion();
        Set predicates = ResolverSupport.getPredicates(null, EvaluableFooCriterion.class, (CriterionPredicateRegistry)registry);
        Assert.assertNotNull((Object)predicates);
        Assert.assertEquals((int)predicates.size(), (int)0);
        CriteriaSet criteria = new CriteriaSet();
        predicates = ResolverSupport.getPredicates((CriteriaSet)criteria, EvaluableFooCriterion.class, (CriterionPredicateRegistry)registry);
        Assert.assertNotNull((Object)predicates);
        Assert.assertEquals((int)predicates.size(), (int)0);
        criteria.clear();
        criteria.add((Object)evaluableCriterion);
        predicates = ResolverSupport.getPredicates((CriteriaSet)criteria, EvaluableFooCriterion.class, (CriterionPredicateRegistry)registry);
        Assert.assertNotNull((Object)predicates);
        Assert.assertEquals((int)predicates.size(), (int)1);
        Assert.assertTrue((boolean)predicates.contains(evaluableCriterion));
        criteria.clear();
        criteria.add((Object)new TestCriterion());
        predicates = ResolverSupport.getPredicates((CriteriaSet)criteria, EvaluableFooCriterion.class, (CriterionPredicateRegistry)registry);
        Assert.assertNotNull((Object)predicates);
        Assert.assertEquals((int)predicates.size(), (int)1);
        Assert.assertTrue((boolean)FooPredicate.class.isInstance(predicates.iterator().next()));
    }

    @Test
    public void testGetFilteredIterable() {
        Foo foo1 = new Foo();
        Foo foo2 = new Foo();
        Iterable result = ResolverSupport.getFilteredIterable(null, (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        HashSet resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)2);
        Assert.assertTrue((boolean)resultSet.contains(foo1));
        Assert.assertTrue((boolean)resultSet.contains(foo2));
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(false)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true), new EvaluableTestFooCriterion(true)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)2);
        Assert.assertTrue((boolean)resultSet.contains(foo1));
        Assert.assertTrue((boolean)resultSet.contains(foo2));
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true), new EvaluableTestFooCriterion(false)}), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet((Object[])new Predicate[]{new EvaluableTestFooCriterion(true), new EvaluableTestFooCriterion(false)}), (boolean)true, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)2);
        Assert.assertTrue((boolean)resultSet.contains(foo1));
        Assert.assertTrue((boolean)resultSet.contains(foo2));
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet(), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)2);
        Assert.assertTrue((boolean)resultSet.contains(foo1));
        Assert.assertTrue((boolean)resultSet.contains(foo2));
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), null, (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)2);
        Assert.assertTrue((boolean)resultSet.contains(foo1));
        Assert.assertTrue((boolean)resultSet.contains(foo2));
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), (Set)Sets.newHashSet(), (boolean)false, (boolean)true);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
        result = ResolverSupport.getFilteredIterable((Iterable)Sets.newHashSet((Object[])new Foo[]{foo1, foo2}), null, (boolean)false, (boolean)true);
        Assert.assertNotNull((Object)result);
        resultSet = Sets.newHashSet((Iterable)result);
        Assert.assertEquals((int)resultSet.size(), (int)0);
    }
}

