/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletResponseProxy;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ThreadLocalHttpServletResponseProxyTest {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setContentType("text/html");
        mockResponse.setCharacterEncoding("UTF-8");
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testResponseNoLoad() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        ThreadLocalHttpServletResponseProxy proxy = new ThreadLocalHttpServletResponseProxy();
        proxy.getContentType();
    }

    @Test
    public void testResponse() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ThreadLocalHttpServletResponseProxy proxy = new ThreadLocalHttpServletResponseProxy();
        Assert.assertEquals((String)proxy.getContentType(), (String)"text/html;charset=UTF-8");
        Assert.assertEquals((String)proxy.getCharacterEncoding(), (String)"UTF-8");
        Assert.assertTrue((boolean)proxy.containsHeader("MyResponseHeader"));
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }
}

