/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestProxy;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ThreadLocalHttpServletRequestProxyTest {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testRequestNoLoad() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        ThreadLocalHttpServletRequestProxy proxy = new ThreadLocalHttpServletRequestProxy();
        proxy.getMethod();
    }

    @Test
    public void testRequest() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ThreadLocalHttpServletRequestProxy proxy = new ThreadLocalHttpServletRequestProxy();
        Assert.assertEquals((String)proxy.getMethod(), (String)"GET");
        Assert.assertEquals((String)proxy.getRequestURI(), (String)"/foo");
        Assert.assertEquals((String)proxy.getHeader("MyRequestHeader"), (String)"MyRequestHeaderValue");
        Assert.assertEquals((String)proxy.getParameter("MyParam"), (String)"MyParamValue");
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }
}

