/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpClientSupportTest {
    @Test
    public void testAddDynamicContextHandlerFirst() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(three, two, one));
    }

    @Test
    public void testAddDynamicContextHandlerLast() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(one, two, three));
    }

    @Test
    public void testAddDynamicContextHandlerFirstUniqueInstances() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(three, two, one));
    }

    @Test
    public void testAddDynamicContextHandlerLastUniqueInstances() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(one, two, three));
    }

    @Test
    public void testAddDynamicContextHandlerFirstUniqueType() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three, (boolean)true);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), Collections.singletonList(one));
    }

    @Test
    public void testAddDynamicContextHandlerLastUniqueType() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three, (boolean)true);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), Collections.singletonList(one));
    }

    public class TestContextHandler
    implements HttpClientContextHandler {
        public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
        }

        public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
        }
    }
}

