/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.component;

import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractInitializableComponentTest {
    @Test
    public void testInitialization() throws Exception {
        MockComponent component = new MockComponent();
        Assert.assertFalse((boolean)component.isInitialized());
        Assert.assertEquals((int)component.getInitCount(), (int)0);
        component.initialize();
        Assert.assertTrue((boolean)component.isInitialized());
        Assert.assertEquals((int)component.getInitCount(), (int)1);
        component.initialize();
        Assert.assertTrue((boolean)component.isInitialized());
        Assert.assertEquals((int)component.getInitCount(), (int)1);
    }

    public class MockComponent
    extends AbstractInitializableComponent {
        private int initCount;

        protected int getInitCount() {
            return this.initCount;
        }

        protected void doInitialize() throws ComponentInitializationException {
            ++this.initCount;
            super.doInitialize();
        }
    }
}

