/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.logic.TransformAndCheckFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CollectionTest {
    private static final String STRING_1 = "StringOne";
    private static final String STRING_2 = "StringTwo";
    private static final String STRING_3 = "StringThree";
    public static final Function<String, Optional<? extends String>> nullRemoveFunction = new TransformAndCheckFunction((Function)Functions.identity(), (Predicate)Predicates.notNull(), false);
    public static final Function<String, Optional<? extends String>> upcaseNotNull = new TransformAndCheckFunction((Function)new UpcaseFunction(), (Predicate)Predicates.notNull(), false);

    @Test
    public void verifyTests() {
        CollectionTest.testSimpleCollection(new ArrayList<String>(), true);
        CollectionTest.testArrayCollection(new ArrayList<String>(), new ArrayList<String>());
        CollectionTest.testIteratorCollection((Collection<String>)new LazyList(), new ArrayList<String>());
        CollectionTest.testSimpleCollection(new HashSet<String>(), false);
        CollectionTest.testArrayCollection(new HashSet<String>(), new HashSet<String>());
        CollectionTest.testIteratorCollection(new HashSet<String>(), new HashSet<String>());
    }

    protected static void testArrayCollection(Collection<String> testCollection, Collection<String> knownGoodCollection) {
        HashSet<String> set = new HashSet<String>(2);
        Object[] testArray1 = testCollection.toArray();
        Object[] knownGood1 = knownGoodCollection.toArray();
        Assert.assertEquals((Object[])testArray1, (Object[])knownGood1, (String)"Results should be the same (modulo ordering issues)");
        Object[] testArray2 = testCollection.toArray(new String[0]);
        Object[] knownGood2 = knownGoodCollection.toArray(testArray2);
        Assert.assertEquals((Object[])testArray2, (Object[])knownGood2, (String)"Results should be the same (modulo ordering issues)");
        set.add(STRING_1);
        testCollection.addAll(set);
        knownGoodCollection.addAll(set);
        testArray1 = testCollection.toArray();
        knownGood1 = knownGoodCollection.toArray();
        Assert.assertEquals((Object[])testArray1, (Object[])knownGood1, (String)"Results should be the same (modulo ordering issues)");
        testArray2 = testCollection.toArray(new String[0]);
        knownGood2 = (String[])knownGoodCollection.toArray(testArray2);
        Assert.assertEquals((Object[])testArray2, (Object[])knownGood2, (String)"Results should be the same (modulo ordering issues)");
        testCollection.add(STRING_1);
        testCollection.add(STRING_3);
        testCollection.addAll(set);
        knownGoodCollection.add(STRING_1);
        knownGoodCollection.add(STRING_3);
        knownGoodCollection.addAll(set);
        testArray1 = testCollection.toArray();
        knownGood1 = knownGoodCollection.toArray();
        Assert.assertEquals((Object[])testArray1, (Object[])knownGood1, (String)"Results should be the same (modulo ordering issues)");
        testArray2 = testCollection.toArray(new String[0]);
        knownGood2 = (String[])knownGoodCollection.toArray(testArray2);
        Assert.assertEquals((Object[])testArray2, (Object[])knownGood2, (String)"Results should be the same (modulo ordering issues)");
    }

    protected static void testIteratorCollection(Collection<String> testCollection, Collection<String> workCollection) {
        Iterator<String> iterator = testCollection.iterator();
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Empty set should not have an iterator.next");
        testCollection.add(STRING_1);
        iterator = testCollection.iterator();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Singleton set should have an iterator.next");
        Assert.assertEquals((String)iterator.next(), (String)STRING_1, (String)"Singleton set should have the correct contents");
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Singleton set should not have a second iterator.next");
        testCollection.add(STRING_2);
        iterator = testCollection.iterator();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Pair set should have an iterator.next");
        String s1 = iterator.next();
        Assert.assertTrue((STRING_1.equals(s1) || STRING_2.equals(s1) ? 1 : 0) != 0, (String)"Pair set should have the correct contents");
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Pair set should have a second iterator.next");
        String s2 = iterator.next();
        Assert.assertTrue((STRING_1.equals(s2) || STRING_2.equals(s2) ? 1 : 0) != 0, (String)"Pair set should have the correct contents");
        Assert.assertNotSame((Object)s1, (Object)s2, (String)"Pair set should have the correct contents");
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Pair set should not have a third iterator.next");
        testCollection.add(STRING_3);
        iterator = testCollection.iterator();
        workCollection.addAll(testCollection);
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)workCollection.remove(iterator.next()), (String)"Should be able to remove every element");
            iterator.remove();
        }
        Assert.assertTrue((boolean)workCollection.isEmpty(), (String)"everything gone after iterate and empty");
        Assert.assertTrue((boolean)testCollection.isEmpty(), (String)"everything gone after iterate and empty");
        iterator = testCollection.iterator();
        try {
            iterator.remove();
            Assert.assertTrue((boolean)false, (String)"Should throw an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        testCollection.clear();
        testCollection.add(STRING_1);
        iterator = testCollection.iterator();
        Assert.assertTrue((boolean)iterator.hasNext(), (String)"Should have a first element");
        iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext(), (String)"Should not have a second element");
        iterator.remove();
    }

    protected static void testSimpleCollection(Collection<String> collection, boolean allowDuplicates) {
        Assert.assertTrue((boolean)collection.isEmpty(), (String)"Start condition is empty");
        Assert.assertEquals((int)collection.size(), (int)0, (String)"Start condition is empty");
        Assert.assertTrue((boolean)collection.add(STRING_1), (String)"Should be allowed to add");
        Assert.assertFalse((boolean)collection.isEmpty(), (String)"Non empty if filled");
        Assert.assertEquals((int)collection.size(), (int)1, (String)"One Element after filling up");
        Assert.assertTrue((boolean)collection.add(STRING_2), (String)"Should be allowed to add");
        Assert.assertFalse((boolean)collection.isEmpty(), (String)"Non empty if filled");
        Assert.assertEquals((int)collection.size(), (int)2, (String)"Two Elements after filling up");
        Assert.assertEquals((boolean)collection.add(STRING_2), (boolean)allowDuplicates, (String)"Only add if duplicates allowed");
        Assert.assertFalse((boolean)collection.isEmpty(), (String)"Non empty if filled");
        if (allowDuplicates) {
            Assert.assertEquals((int)collection.size(), (int)3, (String)"Three Elements after filling up (allowing for duplicates)");
        } else {
            Assert.assertEquals((int)collection.size(), (int)2, (String)"Two Element after filling up (allowing for duplicates)");
        }
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty(), (String)"Empty after emptying");
        Assert.assertEquals((int)collection.size(), (int)0, (String)"Empty after emptying");
        collection.add(STRING_1);
        Assert.assertEquals((int)collection.size(), (int)1, (String)"After adding one");
        Assert.assertFalse((boolean)collection.remove(STRING_2), (String)"Cannot remove if not there");
        Assert.assertTrue((boolean)collection.remove(STRING_1), (String)"Must remove if there");
        Assert.assertTrue((boolean)collection.isEmpty(), (String)"Not there after removal");
        collection.add(STRING_1);
        collection.add(STRING_2);
        collection.add(STRING_3);
        HashSet<String> set = new HashSet<String>(2);
        set.add(STRING_1);
        set.add(STRING_2);
        Assert.assertTrue((boolean)collection.containsAll(set), (String)"Should contain a subset");
        Assert.assertTrue((boolean)collection.removeAll(set), (String)"Should be able to remove subset");
        Assert.assertFalse((boolean)collection.containsAll(set), (String)"Shouldn't contain a subset");
        Assert.assertFalse((boolean)collection.removeAll(set), (String)"Shouldn't be able to remove subset");
        collection.add(STRING_1);
        Assert.assertFalse((boolean)collection.containsAll(set), (String)"Should not contain a subset");
        Assert.assertTrue((boolean)collection.removeAll(set), (String)"Should be able to remove subset");
        Assert.assertFalse((boolean)collection.containsAll(set), (String)"Shouldn't contain a subset");
        Assert.assertFalse((boolean)collection.removeAll(set), (String)"Shouldn't be able to remove subset");
        collection.clear();
        collection.add(STRING_1);
        collection.add(STRING_3);
        Assert.assertTrue((boolean)collection.retainAll(set), (String)"Should be remove something with first retain");
        Assert.assertEquals((int)collection.size(), (int)1, (String)"Contain only one element after retainall");
        Assert.assertFalse((boolean)collection.retainAll(set), (String)"Second retainall should make no difference");
        Assert.assertTrue((boolean)collection.contains(STRING_1), (String)"After retain should just contain the intersection");
        collection.clear();
        Assert.assertTrue((boolean)collection.addAll(set), (String)"Should be allowed to add");
        Assert.assertEquals((int)collection.size(), (int)2, (String)"Contain two elements after addall");
        Assert.assertTrue((boolean)collection.containsAll(set), (String)"Should contain what was added");
        Assert.assertEquals((boolean)collection.addAll(set), (boolean)allowDuplicates, (String)"May be allowed to add");
        if (allowDuplicates) {
            Assert.assertEquals((int)collection.size(), (int)(2 * set.size()), (String)"Count after adding twice");
        } else {
            Assert.assertEquals((int)collection.size(), (int)set.size(), (String)"Count after adding twice");
        }
        Assert.assertTrue((boolean)collection.removeAll(set), (String)"Should be able to remove all");
        Assert.assertTrue((boolean)collection.isEmpty(), (String)"Empty after remove all");
        Assert.assertFalse((boolean)collection.removeAll(set), (String)"Should not be able to remove all twice");
        collection.add(STRING_1);
        Assert.assertTrue((boolean)collection.addAll(set), (String)"Should be allowed to add");
        if (allowDuplicates) {
            Assert.assertEquals((int)collection.size(), (int)(1 + set.size()), (String)"Count after adding individual and set");
        } else {
            Assert.assertEquals((int)collection.size(), (int)set.size(), (String)"Count after adding individual and set");
        }
        Assert.assertTrue((boolean)collection.removeAll(set), (String)"Should be able to remove all");
        Assert.assertTrue((boolean)collection.isEmpty(), (String)"Empty after remove all");
        Assert.assertFalse((boolean)collection.removeAll(set), (String)"Should not be able to remove all twice");
    }

    public static class UpcaseFunction
    implements Function<String, String> {
        @Override
        public String apply(String input) {
            if (null == input) {
                return null;
            }
            return input.toUpperCase();
        }
    }
}

