/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DOMTypeSupportTest {
    private ParserPool parserPool;
    private Element xsStringXSITypeElement;
    private Element noXSITypeElement;

    @BeforeClass
    public void setup() throws ComponentInitializationException, SAXException, IOException, XMLParserException {
        BasicParserPool pool = new BasicParserPool();
        pool.initialize();
        this.parserPool = pool;
        DocumentBuilder builder = this.parserPool.getBuilder();
        ClassPathResource res = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/getXSIType.xml");
        this.xsStringXSITypeElement = (Element)builder.parse(res.getInputStream()).getFirstChild();
        res = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/noXSIType.xml");
        this.noXSITypeElement = (Element)builder.parse(res.getInputStream()).getFirstChild();
        if (null != builder) {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testInstantToString() {
        Assert.assertEquals((String)DOMTypeSupport.instantToString((Instant)Instant.EPOCH.plusMillis(1000L)), (String)"1970-01-01T00:00:01.000Z", (String)"Epoch plus one second");
        Assert.assertEquals((String)DOMTypeSupport.instantToString((Instant)Instant.EPOCH.plusMillis(-1000L)), (String)"1969-12-31T23:59:59.000Z", (String)"Epoch minus one second");
    }

    @Test
    public void testStringToDuration() {
        Assert.assertEquals((Object)DOMTypeSupport.stringToDuration((String)"P0Y0M0DT00H00M01S"), (Object)Duration.ofSeconds(1L), (String)"One second duration");
        Assert.assertEquals((Object)DOMTypeSupport.stringToDuration((String)"-P1D"), (Object)Duration.ofDays(-1L), (String)"Back One day duration");
    }

    @Test
    public void testDurationToString() {
        String onesec = DOMTypeSupport.durationToString((Duration)Duration.ofSeconds(1L));
        Assert.assertTrue(("P0Y0M0DT0H0M1.000S".equals(onesec) || "PT1.000S".equals(onesec) ? 1 : 0) != 0, (String)"One second duration");
        String backday = DOMTypeSupport.durationToString((Duration)Duration.ofDays(-1L));
        Assert.assertTrue(("-P0Y0M1DT0H0M0.000S".equals(backday) || "-P1DT0H0M0.000S".equals(backday) ? 1 : 0) != 0, (String)"Back one day duration");
    }

    @Test
    public void testGetXSIType() {
        Assert.assertEquals((Object)DOMTypeSupport.getXSIType((Element)this.xsStringXSITypeElement), (Object)new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"), (String)"XSI type clash");
        Assert.assertNull((Object)DOMTypeSupport.getXSIType((Element)this.noXSITypeElement), (String)"No xsiType expected");
    }

    @Test
    public void testHasXSIType() {
        Assert.assertTrue((boolean)DOMTypeSupport.hasXSIType((Element)this.xsStringXSITypeElement), (String)" Expected xsi:type");
        Assert.assertFalse((boolean)DOMTypeSupport.hasXSIType((Element)this.noXSITypeElement), (String)"No xsiType expected");
    }
}

