/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.test.repository;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class RepositorySupport {
    private RepositorySupport() {
    }

    public static String buildHTTPSResourceURL(@Nonnull String repoName, @Nonnull String resourcePath) {
        return RepositorySupport.buildHTTPResourceURL(repoName, resourcePath, true);
    }

    public static String buildHTTPResourceURL(@Nonnull String repoName, @Nonnull String resourcePath, boolean https) {
        String repo = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)repoName), (String)"Repository name was null or empty");
        String path = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)resourcePath), (String)"Resource path was null or empty");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (https) {
            return String.format("https://test.shibboleth.net/git/view/?p=%s.git&a=blob_plain&f=%s&hb=HEAD", repo, path);
        }
        return String.format("http://git.shibboleth.net/view/?p=%s.git&a=blob_plain&f=%s&hb=HEAD", repo, path);
    }
}

