/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import java.io.File;
import java.security.KeyException;
import java.time.Duration;
import net.shibboleth.utilities.java.support.security.BasicKeystoreKeyStrategyTool;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import net.shibboleth.utilities.java.support.test.resource.TestResourceConverter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BasicKeystoreKeyStrategyTest {
    @Test
    public void testBasicKeystoreKeyStrategy() throws Exception {
        File keystoreFile = new File("src/test/resources/net/shibboleth/utilities/java/support/security/Temp.jks");
        File versionFile = new File("src/test/resources/net/shibboleth/utilities/java/support/security/Temp.kver");
        keystoreFile.deleteOnExit();
        versionFile.deleteOnExit();
        BasicKeystoreKeyStrategyTool tool = new BasicKeystoreKeyStrategyTool();
        tool.setKeyAlias("secret");
        tool.setKeystorePassword("password");
        tool.setKeystoreFile(keystoreFile);
        tool.setVersionFile(versionFile);
        tool.setKeyCount(3);
        tool.changeKey();
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("password");
        strategy.setKeystorePassword("password");
        strategy.setKeystoreResource(TestResourceConverter.of((Resource)new FileSystemResource(keystoreFile)));
        strategy.setKeyVersionResource(TestResourceConverter.of((Resource)new FileSystemResource(versionFile)));
        strategy.setUpdateInterval(Duration.ofSeconds(1L));
        strategy.initialize();
        Assert.assertEquals((String)((String)strategy.getDefaultKey().getFirst()), (String)"secret1");
        try {
            strategy.getKey("secret2");
            Assert.fail();
        }
        catch (KeyException keyException) {
            // empty catch block
        }
        tool.changeKey();
        Thread.sleep(2000L);
        Assert.assertEquals((String)((String)strategy.getDefaultKey().getFirst()), (String)"secret2");
        Assert.assertNotNull((Object)strategy.getKey("secret1"));
        tool.changeKey();
        tool.changeKey();
        Thread.sleep(2000L);
        Assert.assertEquals((String)((String)strategy.getDefaultKey().getFirst()), (String)"secret4");
        Assert.assertNotNull((Object)strategy.getKey("secret2"));
        Assert.assertNotNull((Object)strategy.getKey("secret3"));
        try {
            strategy.getKey("secret1");
            Assert.fail();
        }
        catch (KeyException keyException) {
            // empty catch block
        }
    }
}

