/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.primitive;

import com.google.common.base.Objects;
import net.shibboleth.utilities.java.support.primitive.ObjectSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObjectSupportTest {
    @Test
    public void testFirstNonNull() {
        Object foo = new Object();
        Object bar = new Object();
        Object baz = new Object();
        Assert.assertSame((Object)ObjectSupport.firstNonNull((Object[])new Object[]{foo, bar}), (Object)foo);
        Assert.assertSame((Object)ObjectSupport.firstNonNull((Object[])new Object[]{foo, bar, baz}), (Object)foo);
        Assert.assertSame((Object)ObjectSupport.firstNonNull((Object[])new Object[]{null, bar, baz}), (Object)bar);
        Assert.assertSame((Object)ObjectSupport.firstNonNull((Object[])new Object[]{null, null, baz}), (Object)baz);
        Assert.assertNull((Object)ObjectSupport.firstNonNull((Object[])new Object[]{null, null, null, null}));
        Assert.assertNull((Object)ObjectSupport.firstNonNull((Object[])new Object[0]));
    }

    @Test
    public void testHashCode() {
        ComplexClass c1 = new ComplexClass(1, 3.4, "String!");
        ComplexClass c2 = new ComplexClass("String3", 1243, false);
        Assert.assertEquals((int)ObjectSupport.hashCode(null), (int)0, (String)"Hashcode of null is 0");
        Assert.assertEquals((int)ObjectSupport.hashCode((Object)c1), (int)c1.hashCode(), (String)"Hashcode of should be the same no matter how called");
        Assert.assertEquals((int)ObjectSupport.hashCode((Object)c2), (int)c2.hashCode(), (String)"Hashcode of should be the same no matter how called");
        Assert.assertNotSame((Object)ObjectSupport.hashCode((Object)c1), (Object)ObjectSupport.hashCode((Object)c2), (String)"Hashcode of different objects should differ");
        Assert.assertEquals((int)c2.getHashCalls(), (int)3, (String)"Hashcode should have been called three times");
    }

    private class ComplexClass {
        private Object object1;
        private Object object2;
        private Object object3;
        private int hashCalls;

        public int getHashCalls() {
            return this.hashCalls;
        }

        ComplexClass(Object o1, Object o2, Object o3) {
            this.object1 = o1;
            this.object2 = o2;
            this.object3 = o3;
        }

        public int hashCode() {
            ++this.hashCalls;
            return Objects.hashCode((Object[])new Object[]{this.object1, this.object2, this.object3});
        }
    }
}

