/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.net.MalformedURLException;
import net.shibboleth.utilities.java.support.net.SimpleURLCanonicalizer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimpleURLCanonicalizerTest {
    @Test
    public void testScheme() throws MalformedURLException {
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"HttPS://www.example.org/Foo/Bar/baz"), (String)"https://www.example.org/Foo/Bar/baz");
    }

    @Test
    public void testHostname() throws MalformedURLException {
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"https://WWW.eXample.orG/Foo/Bar/baz"), (String)"https://www.example.org/Foo/Bar/baz");
    }

    @Test
    public void testPort() throws MalformedURLException {
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"https://www.example.org:443/Foo/Bar/baz"), (String)"https://www.example.org/Foo/Bar/baz");
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"https://www.example.org:8443/Foo/Bar/baz"), (String)"https://www.example.org:8443/Foo/Bar/baz");
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"http://www.example.org:80/Foo/Bar/baz"), (String)"http://www.example.org/Foo/Bar/baz");
        Assert.assertEquals((String)SimpleURLCanonicalizer.canonicalize((String)"http://www.example.org:8080/Foo/Bar/baz"), (String)"http://www.example.org:8080/Foo/Bar/baz");
        SimpleURLCanonicalizer.registerSchemePortMapping((String)"myscheme", (Integer)1967);
        Assert.assertEquals((Object)SimpleURLCanonicalizer.getRegisteredPort((String)"MyScheme"), (Object)1967);
    }
}

