/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.logic.ScriptedFunction;
import net.shibboleth.utilities.java.support.logic.ScriptedPredicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedTest {
    private static final String returnSelf = "input";
    private static final String returnSelfString = "input.toString()";
    private static final String returnCustom = "custom";

    @Test
    public void testPredicate() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnSelf);
        Assert.assertTrue((boolean)test.test((Object)Boolean.TRUE));
        Assert.assertFalse((boolean)test.test((Object)Boolean.FALSE));
        Assert.assertFalse((boolean)test.test((Object)1));
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.test((Object)1));
    }

    @Test
    public void testPredicateCustom() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnCustom);
        test.setCustomObject((Object)Boolean.TRUE);
        Assert.assertTrue((boolean)test.test((Object)Boolean.FALSE));
        test.setCustomObject((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)test.test((Object)Boolean.TRUE));
        test.setCustomObject((Object)1);
        Assert.assertFalse((boolean)test.test((Object)"true"));
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.test((Object)"false"));
    }

    @Test
    public void testBadScriptPredicate() throws ScriptException {
        ScriptedPredicate test = ScriptedPredicate.inlineScript((String)returnSelfString);
        test.setHideExceptions(true);
        test.setReturnOnError(true);
        Assert.assertTrue((boolean)test.test(null));
        test.setReturnOnError(false);
        Assert.assertFalse((boolean)test.test(null));
        test.setHideExceptions(false);
        try {
            Assert.assertFalse((boolean)test.test(null));
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals(e.getCause().getClass(), ScriptException.class);
        }
    }

    @Test
    public void testFunction() throws ScriptException {
        ScriptedFunction test = ScriptedFunction.inlineScript((String)returnSelf);
        Assert.assertEquals((Object)test.apply((Object)Boolean.FALSE), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)test.apply((Object)Boolean.TRUE), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)test.apply((Object)1), (Object)1);
        test.setOutputType(Boolean.class);
        Assert.assertEquals((Object)test.apply((Object)Boolean.FALSE), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)test.apply((Object)Boolean.TRUE), (Object)Boolean.TRUE);
        Assert.assertNotEquals((Object)test.apply((Object)1), (Object)1);
        test.setReturnOnError((Object)Boolean.TRUE);
        Assert.assertEquals((Object)test.apply((Object)1), (Object)Boolean.TRUE);
    }

    @Test
    public void testBadScriptFunction() throws ScriptException {
        ScriptedFunction test = ScriptedFunction.inlineScript((String)returnSelfString);
        test.setOutputType(Boolean.class);
        test.setInputType(Boolean.class);
        test.setHideExceptions(true);
        test.setReturnOnError((Object)true);
        Assert.assertEquals((Object)test.apply(null), (Object)Boolean.TRUE);
        test.setReturnOnError((Object)false);
        Assert.assertEquals((Object)test.apply(null), (Object)Boolean.FALSE);
        test.setHideExceptions(false);
        try {
            Assert.assertEquals((Object)test.apply(null), (Object)Boolean.TRUE);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals(e.getCause().getClass(), ScriptException.class);
        }
    }
}

