/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.component;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComponentSupportTest {
    @Test
    public void testDestroy() throws ComponentInitializationException {
        ComponentSupport.destroy(null);
        ComponentSupport.destroy((Object)new Object());
        MockDestructableComponent component = new MockDestructableComponent();
        Assert.assertFalse((boolean)component.isDestroyed(), (String)"New component not destroyed");
        ComponentSupport.destroy((Object)component);
        Assert.assertTrue((boolean)component.isDestroyed(), (String)"Destroyed component destroyed");
    }

    @Test
    public void testInitialized() throws ComponentInitializationException {
        ComponentSupport.initialize(null);
        ComponentSupport.initialize((Object)new Object());
        MockInitializableComponent component = new MockInitializableComponent();
        Assert.assertFalse((boolean)component.isInitialized(), (String)"New component not initialized");
        ComponentSupport.initialize((Object)component);
        Assert.assertTrue((boolean)component.isInitialized(), (String)"Initialized component initialized");
    }

    @Test
    public void testIfDestroyedThrowDestroyedComponentException() {
        MockDestructableComponent component = new MockDestructableComponent();
        try {
            ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)component);
        }
        catch (DestroyedComponentException e) {
            Assert.fail();
        }
        component.destroy();
        try {
            ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)component);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        try {
            ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)((DestructableComponent)this.nullValue()));
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testIfNotInitializedThrowUninitializedComponentException() throws Exception {
        MockInitializableComponent component = new MockInitializableComponent();
        try {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)component);
            Assert.fail();
        }
        catch (UninitializedComponentException uninitializedComponentException) {
            // empty catch block
        }
        component.initialize();
        try {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)component);
        }
        catch (UninitializedComponentException e) {
            Assert.fail();
        }
        try {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)((InitializableComponent)this.nullValue()));
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testIfInitializedThrowUnmodifiabledComponentException() throws Exception {
        MockInitializableComponent component = new MockInitializableComponent();
        try {
            ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)component);
        }
        catch (UnmodifiableComponentException e) {
            Assert.fail();
        }
        component.initialize();
        try {
            ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)component);
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
        try {
            ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)((InitializableComponent)this.nullValue()));
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private <T> T nullValue() {
        return null;
    }

    public class MockInitializableComponent
    implements InitializableComponent {
        private boolean initialized;

        public void initialize() throws ComponentInitializationException {
            this.initialized = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private class MockDestructableComponent
    implements DestructableComponent {
        private boolean destroyed;

        private MockDestructableComponent() {
        }

        public void destroy() {
            this.destroyed = true;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }
    }
}

