/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.codec;

import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class Base32SupportTest {
    private static final String PLAIN_TEXT = "test data";
    private static final String ENCODED_TEXT = "ORSXG5BAMRQXIYI=";
    private static final String INVALID_BASE32_TRAILING = "AB======";
    private static final String INVALID_BASE32 = "MC======";

    @Test(expectedExceptions={DecodingException.class})
    public void testDecodeInvalidInput() throws DecodingException {
        Base32Support.decode((String)INVALID_BASE32);
    }

    @Test(expectedExceptions={DecodingException.class})
    public void testDecodeInvalidTrailingBitsInput() throws DecodingException {
        Base32Support.decode((String)INVALID_BASE32_TRAILING);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEncodeNullInput() throws EncodingException {
        Base32Support.encode(null, (boolean)false);
    }

    @Test
    public void testEncode() throws EncodingException {
        Assert.assertEquals((String)ENCODED_TEXT, (String)Base32Support.encode((byte[])PLAIN_TEXT.getBytes(), (boolean)false));
    }
}

