/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.primitive;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeprecationSupport {
    @Nonnull
    @NotEmpty
    public static final String LOG_CATEGORY = "DEPRECATED";
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger((String)"DEPRECATED");
    @Nonnull
    @NonnullElements
    private static final Set<String> WARNED_SET = new HashSet<String>();

    private DeprecationSupport() {
    }

    public static void warn(@Nonnull ObjectType type, @Nonnull @NotEmpty String name, @Nullable String context, @Nullable String replacement) {
        if (context != null && replacement != null) {
            LOG.warn("{} '{}', ({}): This will be removed in the next major version of this software; replacement is {}", new Object[]{type, name, context, replacement});
        } else if (context != null) {
            LOG.warn("{} '{}', ({}): This will be removed in the next major version of this software", new Object[]{type, name, context});
        } else if (replacement != null) {
            LOG.warn("{} '{}': This will be removed in the next major version of this software; replacement is {}", new Object[]{type, name, replacement});
        } else {
            LOG.warn("{} '{}': This will be removed in the next major version of this software.", (Object)type, (Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warnOnce(@Nonnull ObjectType type, @Nonnull @NotEmpty String name, @Nullable String context, @Nullable String replacement) {
        Set<String> set = WARNED_SET;
        synchronized (set) {
            if (!WARNED_SET.add(type.toString() + ":" + name)) {
                return;
            }
        }
        DeprecationSupport.warn(type, name, context, replacement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearWarningState() {
        Set<String> set = WARNED_SET;
        synchronized (set) {
            WARNED_SET.clear();
        }
    }

    public static enum ObjectType {
        CLASS("Java class"),
        METHOD("Java class method"),
        PROPERTY("property"),
        BEAN("Spring bean"),
        NAMESPACE("XML Namespace"),
        XSITYPE("xsi:type"),
        ELEMENT("XML Element"),
        ATTRIBUTE("XML Attribute"),
        WEBFLOW("Spring WebFlow"),
        ACTION("Spring WebFlow action"),
        CONFIGURATION("configuration");

        @Nonnull
        @NotEmpty
        private final String text;

        private ObjectType(String s) {
            this.text = s;
        }

        public String toString() {
            return this.text;
        }
    }
}

