/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Predicate;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedPredicate<T>
extends AbstractScriptEvaluator
implements Predicate<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedPredicate.class);

    protected ScriptedPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Scripted Predicate from " + extraInfo + ":");
    }

    protected ScriptedPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous Scripted Predicate:");
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
    }

    public void setReturnOnError(boolean flag) {
        this.setReturnOnError((Object)flag);
    }

    @Override
    public boolean test(@Nullable T input) {
        Object result = this.evaluate(input);
        return (Boolean)(result != null ? result : this.getReturnOnError());
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input", input[0], 100);
    }

    public static <T> ScriptedPredicate<T> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript(engineName, is);
            ScriptedPredicate<T> scriptedPredicate = new ScriptedPredicate<T>(script, resource.getDescription());
            return scriptedPredicate;
        }
    }

    public static <T> ScriptedPredicate<T> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedPredicate.resourceScript("JavaScript", resource);
    }

    public static <T> ScriptedPredicate<T> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedPredicate<T>(script, "Inline");
    }

    public static <T> ScriptedPredicate<T> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript("JavaScript", scriptSource);
        return new ScriptedPredicate<T>(script, "Inline");
    }
}

