/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.scripting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class EvaluableScriptTest {
    private static final String SCRIPT_LANGUAGE = "JavaScript";
    private static final String TEST_SIMPLE_SCRIPT = "importPackage(Packages.net.shibboleth.idp.attribute);\nfoo = res = new Attribute(\"bar\");\n foo.addValue(\"value\");\n";
    private File theFile;

    @AfterClass
    public void deleteFile() {
        if (null != this.theFile && this.theFile.exists()) {
            this.theFile.delete();
        }
    }

    @Test
    public void testEvaluableScript() throws ScriptException, IOException {
        new EvaluableScript(SCRIPT_LANGUAGE, TEST_SIMPLE_SCRIPT);
        try {
            new EvaluableScript(" ", TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, " ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(null, TEST_SIMPLE_SCRIPT);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, (String)null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        this.theFile = File.createTempFile("EvaluableScriptTest", ".js");
        FileWriter s = new FileWriter(this.theFile);
        s.write(TEST_SIMPLE_SCRIPT, 0, TEST_SIMPLE_SCRIPT.length());
        s.close();
        Assert.assertEquals((String)new EvaluableScript(SCRIPT_LANGUAGE, this.theFile).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        try (FileInputStream is = new FileInputStream(this.theFile);){
            Assert.assertEquals((String)new EvaluableScript(SCRIPT_LANGUAGE, (InputStream)is).getScriptLanguage(), (String)SCRIPT_LANGUAGE);
        }
        try {
            new EvaluableScript(null, this.theFile);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new EvaluableScript(SCRIPT_LANGUAGE, (File)null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

