/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import com.google.common.collect.Sets;
import com.google.common.net.MediaType;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpServletSupportTest {
    @Test
    public void testAddNoCacheHeaders() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)response.getHeaderValue("Cache-control"));
        Assert.assertNull((Object)response.getHeaderValue("Pragma"));
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        Assert.assertEquals((Object)response.getHeaderValue("Cache-control"), (Object)"no-cache, no-store");
        Assert.assertEquals((Object)response.getHeaderValue("Pragma"), (Object)"no-cache");
    }

    @Test
    public void testGetFullRequestURI() {
    }

    @Test
    public void testGetRequestPathWithoutContext() {
    }

    @Test
    public void testSetContentType() {
    }

    @Test
    public void testSetUTF8Encoding() {
    }

    @Test
    public void testValidateContentType() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8}), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8}), (boolean)false, (boolean)false));
        request.setContentType("text/xml; charset=utf-8");
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8.withoutParameters(), MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.ANY_TEXT_TYPE, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.ANY_TYPE, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        request.setContentType("text/xml");
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.XML_UTF_8.withoutParameters(), MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.ANY_TEXT_TYPE, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)Sets.newHashSet((Object[])new MediaType[]{MediaType.ANY_TYPE, MediaType.create((String)"application", (String)"foobar")}), (boolean)true, (boolean)true));
    }
}

