/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractDateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClassToInstanceMultiMapTest {
    @Test
    public void testClearIsEmpty() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
        map.put(new Object());
        Assert.assertFalse((boolean)map.isEmpty());
        map.clear();
        Assert.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testKeysAndContainsKey() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        Assert.assertEquals((int)map.keys().size(), (int)2);
        Assert.assertFalse((boolean)map.containsKey(null));
        Assert.assertFalse((boolean)map.containsKey(Chronology.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractInstant.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractDateTime.class));
        Assert.assertFalse((boolean)map.containsKey(BaseDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(DateTime.class));
        Assert.assertFalse((boolean)map.containsKey(Comparable.class));
        Assert.assertFalse((boolean)map.containsKey(ReadableDateTime.class));
        Assert.assertFalse((boolean)map.containsKey(ReadableInstant.class));
        Assert.assertFalse((boolean)map.containsKey(Serializable.class));
        Assert.assertTrue((boolean)map.containsKey(Instant.class));
        map = new ClassToInstanceMultiMap(true);
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        Assert.assertEquals((int)map.keys().size(), (int)9);
        Assert.assertFalse((boolean)map.containsKey(null));
        Assert.assertFalse((boolean)map.containsKey(Chronology.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractInstant.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(BaseDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(DateTime.class));
        Assert.assertTrue((boolean)map.containsKey(Comparable.class));
        Assert.assertTrue((boolean)map.containsKey(ReadableDateTime.class));
        Assert.assertTrue((boolean)map.containsKey(ReadableInstant.class));
        Assert.assertTrue((boolean)map.containsKey(Serializable.class));
        Assert.assertTrue((boolean)map.containsKey(Instant.class));
    }

    @Test
    public void testValuesAndContainsValues() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        DateTimeZone notUTC = DateTimeZone.forID((String)"America/Los_Angeles");
        DateTime now = new DateTime((Chronology)ISOChronology.getInstance((DateTimeZone)notUTC));
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
        Assert.assertFalse((boolean)now.equals((Object)instant), (String)"now is equals to instant; test assumption violated");
        Assert.assertEquals((int)map.values().size(), (int)3);
        Assert.assertFalse((boolean)map.containsValue(null));
        Assert.assertFalse((boolean)map.containsValue((Object)now.minus(100L)));
        Assert.assertFalse((boolean)map.containsValue((Object)instant.minus(100L)));
        Assert.assertTrue((boolean)map.containsValue((Object)instant));
        Assert.assertTrue((boolean)map.containsValue((Object)now));
        Assert.assertTrue((boolean)map.containsValue((Object)now100));
    }

    @Test
    public void testEquals() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        ClassToInstanceMultiMap map2 = new ClassToInstanceMultiMap();
        ClassToInstanceMultiMap map3 = new ClassToInstanceMultiMap();
        DateTime now = new DateTime();
        map.put((Object)now);
        map2.put((Object)now);
        map3.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        map2.put((Object)now100);
        map3.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
        map2.put((Object)instant);
        Assert.assertTrue((boolean)map.equals((Object)map2));
        Assert.assertFalse((boolean)map.equals((Object)map3));
        Assert.assertEquals((int)map.hashCode(), (int)map2.hashCode());
        Assert.assertNotEquals((Object)map.hashCode(), (Object)map3.hashCode());
    }

    @Test
    public void testGet() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap();
        this.populate((ClassToInstanceMultiMap<AbstractInstant>)map);
        List values = map.get(null);
        Assert.assertEquals((int)values.size(), (int)0);
        values = map.get(DateTime.class);
        Assert.assertEquals((int)values.size(), (int)2);
        values = map.get(Instant.class);
        Assert.assertEquals((int)values.size(), (int)1);
    }

    @Test
    public void testNoIndexedDuplicateValues() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap(true);
        map.put((Object)new FooBarImpl());
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)1);
    }

    @Test
    public void testDuplicateInsertions() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        map.put((Object)fb);
        map.put((Object)fb);
        Assert.assertEquals((int)map.values().size(), (int)1);
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)1);
    }

    @Test
    public void testRemoveValue() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        FooImpl f = new FooImpl();
        map.put((Object)fb);
        map.put((Object)f);
        Assert.assertTrue((boolean)map.containsValue((Object)fb));
        Assert.assertTrue((boolean)map.containsValue((Object)f));
        Assert.assertTrue((boolean)map.containsKey(Foo.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKey(FooImpl.class));
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)2);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)2);
        Assert.assertEquals((int)map.get(FooImpl.class).size(), (int)1);
        Assert.assertTrue((boolean)map.containsKey(Bar.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFooBar.class));
        Assert.assertTrue((boolean)map.containsKey(FooBarImpl.class));
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)1);
        map.remove((Object)fb);
        Assert.assertFalse((boolean)map.containsValue((Object)fb));
        Assert.assertTrue((boolean)map.containsValue((Object)f));
        Assert.assertTrue((boolean)map.containsKey(Foo.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKey(FooImpl.class));
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooImpl.class).size(), (int)1);
        Assert.assertFalse((boolean)map.containsKey(Bar.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractFooBar.class));
        Assert.assertFalse((boolean)map.containsKey(FooBarImpl.class));
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)0);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)0);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)0);
    }

    @Test
    public void testRemoveByType() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap(true);
        FooBarImpl fb = new FooBarImpl();
        FooImpl f = new FooImpl();
        map.put((Object)fb);
        map.put((Object)f);
        Assert.assertTrue((boolean)map.containsValue((Object)fb));
        Assert.assertTrue((boolean)map.containsValue((Object)f));
        Assert.assertTrue((boolean)map.containsKey(Foo.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKey(FooImpl.class));
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)2);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)2);
        Assert.assertEquals((int)map.get(FooImpl.class).size(), (int)1);
        Assert.assertTrue((boolean)map.containsKey(Bar.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFooBar.class));
        Assert.assertTrue((boolean)map.containsKey(FooBarImpl.class));
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)1);
        map.remove(Bar.class);
        Assert.assertFalse((boolean)map.containsValue((Object)fb));
        Assert.assertTrue((boolean)map.containsValue((Object)f));
        Assert.assertTrue((boolean)map.containsKey(Foo.class));
        Assert.assertTrue((boolean)map.containsKey(AbstractFoo.class));
        Assert.assertTrue((boolean)map.containsKey(FooImpl.class));
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(AbstractFoo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(FooImpl.class).size(), (int)1);
        Assert.assertFalse((boolean)map.containsKey(Bar.class));
        Assert.assertFalse((boolean)map.containsKey(AbstractFooBar.class));
        Assert.assertFalse((boolean)map.containsKey(FooBarImpl.class));
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)0);
        Assert.assertEquals((int)map.get(AbstractFooBar.class).size(), (int)0);
        Assert.assertEquals((int)map.get(FooBarImpl.class).size(), (int)0);
    }

    @Test
    public void testRemoveAll() {
        ClassToInstanceMultiMap map = new ClassToInstanceMultiMap(true);
        FooImpl f1 = new FooImpl();
        FooImpl f2 = new FooImpl();
        FooImpl f3 = new FooImpl();
        FooBarImpl fb1 = new FooBarImpl();
        FooBarImpl fb2 = new FooBarImpl();
        FooBarImpl fb3 = new FooBarImpl();
        map.put((Object)f1);
        map.put((Object)f2);
        map.put((Object)f3);
        map.put((Object)fb1);
        map.put((Object)fb2);
        map.put((Object)fb3);
        Assert.assertEquals((int)map.values().size(), (int)6);
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)6);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)3);
        map.removeAll(Arrays.asList(f1, f2, fb1));
        Assert.assertEquals((int)map.values().size(), (int)3);
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)3);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)2);
        map.removeAll(Arrays.asList(fb2, fb3));
        Assert.assertEquals((int)map.values().size(), (int)1);
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)1);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)0);
        Assert.assertFalse((boolean)map.containsKey(Bar.class));
        map.removeAll(Arrays.asList(f3));
        Assert.assertEquals((int)map.values().size(), (int)0);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((int)map.get(Foo.class).size(), (int)0);
        Assert.assertEquals((int)map.get(Bar.class).size(), (int)0);
        Assert.assertFalse((boolean)map.containsKey(Foo.class));
        Assert.assertFalse((boolean)map.containsKey(Bar.class));
    }

    protected void populate(ClassToInstanceMultiMap<AbstractInstant> map) {
        DateTime now = new DateTime();
        map.put((Object)now);
        DateTime now100 = now.plus(100L);
        map.put((Object)now100);
        Instant instant = new Instant();
        map.put((Object)instant);
    }

    public class FooBarImpl
    extends AbstractFooBar {
    }

    public abstract class AbstractFooBar
    extends AbstractFoo
    implements Bar {
    }

    public class FooImpl
    extends AbstractFoo {
    }

    public abstract class AbstractFoo
    implements Foo {
    }

    public static interface Bar
    extends Foo {
    }

    public static interface Foo {
    }
}

