/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.ResourceException;
import net.shibboleth.utilities.java.support.xml.LoggingErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class SchemaBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaBuilder.class);

    private SchemaBuilder() {
    }

    @Nonnull
    public static Schema buildSchema(@Nonnull SchemaLanguage lang, String ... schemaFilesOrDirectories) throws SAXException {
        Constraint.isNotNull(schemaFilesOrDirectories, "Schema source files paths can not be null");
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String file : schemaFilesOrDirectories) {
            if (file == null) continue;
            sourceFiles.add(new File(file));
        }
        return SchemaBuilder.buildSchema(lang, sourceFiles.toArray(new File[sourceFiles.size()]));
    }

    @Nonnull
    public static Schema buildSchema(@Nonnull SchemaLanguage lang, File ... schemaFilesOrDirectories) throws SAXException {
        Constraint.isNotNull(schemaFilesOrDirectories, "Schema source files can not be null");
        ArrayList<File> schemaFiles = new ArrayList<File>();
        SchemaBuilder.getSchemaFiles(lang, schemaFiles, schemaFilesOrDirectories);
        ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
        for (File schemaFile : schemaFiles) {
            if (schemaFile == null) continue;
            schemaSources.add(new StreamSource(schemaFile));
        }
        return SchemaBuilder.buildSchema(lang, schemaSources);
    }

    @Nonnull
    public static Schema buildSchema(@Nonnull SchemaLanguage lang, Resource ... schemaSources) throws SAXException {
        Constraint.isNotNull(schemaSources, "Schema source resources can not be null");
        ArrayList<StreamSource> sourceStreams = new ArrayList<StreamSource>();
        for (Resource schemaSource : schemaSources) {
            try {
                if (schemaSource == null) continue;
                sourceStreams.add(new StreamSource(schemaSource.getInputStream(), schemaSource.getLocation()));
            }
            catch (ResourceException e) {
                throw new SAXException("Unable to read schema resource " + schemaSource.getLocation(), e);
            }
        }
        return SchemaBuilder.buildSchema(lang, sourceStreams);
    }

    @Nonnull
    public static Schema buildSchema(@Nonnull SchemaLanguage lang, InputStream ... schemaSources) throws SAXException {
        Constraint.isNotNull(schemaSources, "Schema source inputstreams can not be null");
        ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
        for (InputStream schemaSource : schemaSources) {
            if (schemaSource == null) continue;
            sources.add(new StreamSource(schemaSource));
        }
        return SchemaBuilder.buildSchema(lang, sources);
    }

    private static void getSchemaFiles(@Nonnull SchemaLanguage lang, @Nonnull List<File> accumulatedSchemaFiles, File ... schemaFilesOrDirectories) {
        Constraint.isNotNull(lang, "Schema language identifier can not be null");
        Constraint.isNotNull(accumulatedSchemaFiles, "Accumulated schema file collection can not be null");
        Constraint.isNotNull(schemaFilesOrDirectories, "Schema file or directory can not be null");
        for (File handle : schemaFilesOrDirectories) {
            if (handle == null) continue;
            if (!handle.canRead()) {
                LOG.debug("Ignoring '{}', no read permission", (Object)handle.getAbsolutePath());
            }
            if (handle.isFile() && handle.getName().endsWith(lang.getSchemaFileExtension())) {
                LOG.debug("Added schema source '{}'", (Object)handle.getAbsolutePath());
                accumulatedSchemaFiles.add(handle);
            }
            if (!handle.isDirectory()) continue;
            SchemaBuilder.getSchemaFiles(lang, accumulatedSchemaFiles, handle.listFiles());
        }
    }

    @Nonnull
    private static Schema buildSchema(@Nonnull SchemaLanguage lang, @Nonnull @NotEmpty @NullableElements List<? extends Source> schemaSources) throws SAXException {
        Constraint.isNotNull(lang, "Schema language identifier can not be null");
        Constraint.isNotNull(schemaSources, "Schema source files can not be null");
        ArrayList<Source> sources = new ArrayList<Source>();
        for (Source source : schemaSources) {
            if (source == null) continue;
            sources.add(source);
        }
        Constraint.isNotEmpty(sources, "No schema source specified");
        SchemaFactory schemaFactory = lang == SchemaLanguage.XML ? SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema") : SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
        schemaFactory.setErrorHandler(new LoggingErrorHandler(LoggerFactory.getLogger(SchemaBuilder.class)));
        return schemaFactory.newSchema(sources.toArray(new Source[sources.size()]));
    }

    public static enum SchemaLanguage {
        XML("xsd"),
        RELAX("rng");

        private String schemaFileExtension;

        private SchemaLanguage(String extension) {
            this.schemaFileExtension = extension;
        }

        public String getSchemaFileExtension() {
            return this.schemaFileExtension;
        }
    }
}

