/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.AbstractResource;
import net.shibboleth.utilities.java.support.resource.ResourceException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HttpResource
extends AbstractResource {
    public static final String ETAG_PROP = "etag";
    public static final String LAST_MODIFIED_PROP = "modified";
    private final Logger log = LoggerFactory.getLogger(HttpResource.class);
    private HttpClient httpClient;
    private HttpGetCustomizationStrategy httpGetCustomizationStrategy;
    private HttpResponseCustomizationStrategy httpResponseCustomizationStrategy;

    public HttpResource(@Nonnull HttpClient client, @Nonnull @NotEmpty String url) {
        this.httpClient = Constraint.isNotNull(client, "HTTP client may not be null");
        this.setLocation(Constraint.isNotNull(StringSupport.trimOrNull(url), "Resource URL may not be null or empty"));
    }

    @Nullable
    public HttpGetCustomizationStrategy getHttpGetCustomizationStrategy() {
        return this.httpGetCustomizationStrategy;
    }

    public synchronized void setHttpGetCustomizationStrategy(@Nullable HttpGetCustomizationStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        this.httpGetCustomizationStrategy = strategy;
    }

    @Nullable
    public HttpResponseCustomizationStrategy getHttpResponseCustomizationStrategy() {
        return this.httpResponseCustomizationStrategy;
    }

    public synchronized void setHttpResponseCustomizationStrategy(@Nullable HttpResponseCustomizationStrategy strategy) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        this.httpResponseCustomizationStrategy = strategy;
    }

    @Override
    protected long doGetLastModifiedTime() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        try {
            Header httpHeader = this.getResourceHeaders().getFirstHeader("Last-Modified");
            if (httpHeader != null) {
                Date lastModDate = DateUtils.parseDate((String)httpHeader.getValue());
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(lastModDate);
                return cal.getTimeInMillis();
            }
            throw new ResourceException(this.getLocation() + " did not return the required " + "Last-Modified" + " header");
        }
        catch (DateParseException e) {
            throw new ResourceException("Unable to parse HTTP Last-Modified header", (Exception)((Object)e));
        }
    }

    @Override
    protected boolean doExists() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        int statusCode = this.getResourceHeaders().getStatusLine().getStatusCode();
        return statusCode == 200 || statusCode == 304;
    }

    @Override
    @Nonnull
    protected InputStream doGetInputStream() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        HttpGet httpRequest = this.buildGetMethod();
        try {
            this.log.debug("Attempting to fetch data from '{}'", (Object)this.getLocation());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
            int httpStatus = response.getStatusLine().getStatusCode();
            if (httpStatus >= 200 && httpStatus <= 299) {
                HttpEntity responseEntity;
                if (this.httpResponseCustomizationStrategy != null) {
                    response = this.httpResponseCustomizationStrategy.customize(response);
                }
                if ((responseEntity = response.getEntity()) == null) {
                    throw new ResourceException(this.getLocation() + " returned the successful status code " + httpStatus + " but did not return any content");
                }
                return responseEntity.getContent();
            }
            this.log.debug("Unacceptable status code, {}, returned when fetching resource from '{}'", (Object)httpStatus, (Object)this.getLocation());
            throw new ResourceException("Unable to read resource from " + this.getLocation() + ", received a status code of " + httpStatus);
        }
        catch (IOException e) {
            httpRequest.abort();
            throw new ResourceException("Error fetching resource from " + this.getLocation(), e);
        }
    }

    @Override
    protected void doDestroy() {
        this.httpClient.getConnectionManager().shutdown();
        this.httpClient = null;
        this.httpGetCustomizationStrategy = null;
        this.httpResponseCustomizationStrategy = null;
        super.doDestroy();
    }

    private HttpResponse getResourceHeaders() throws ResourceException {
        HttpHead httpRequest = new HttpHead(this.getLocation());
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 405 || statusCode == 501) {
                this.log.debug(this.getLocation() + " does not support HEAD requests, falling back to GET request");
                httpRequest = this.buildGetMethod();
                httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                statusCode = httpResponse.getStatusLine().getStatusCode();
            }
            return httpResponse;
        }
        catch (IOException e) {
            throw new ResourceException("Error contacting resource " + this.getLocation(), e);
        }
    }

    private HttpGet buildGetMethod() {
        HttpGet httpGet = new HttpGet(this.getLocation());
        if (this.httpGetCustomizationStrategy == null) {
            return httpGet;
        }
        return this.httpGetCustomizationStrategy.customize(httpGet);
    }

    @ThreadSafe
    public static interface HttpResponseCustomizationStrategy {
        @Nonnull
        public HttpResponse customize(@Nonnull HttpResponse var1);
    }

    @ThreadSafe
    public static interface HttpGetCustomizationStrategy {
        @Nonnull
        public HttpGet customize(@Nonnull HttpGet var1);
    }
}

