/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.chrono;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.logic.Constraint;

@NotThreadSafe
public class Stopwatch {
    private Long startTime;
    private Long stopTime;
    private long elapsedTime;

    public Stopwatch() {
    }

    public Stopwatch(long startTimeInMillis) {
        this.startTime = startTimeInMillis;
    }

    public long elapsedTime() {
        return this.elapsedTime;
    }

    public long elapsedTime(@Nonnull TimeUnit unit) {
        Constraint.isNotNull(unit, "Provided TimeUnit can not be null");
        return unit.convert(this.elapsedTime, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning() {
        return this.startTime != null && this.stopTime == null;
    }

    public void reset() {
        this.startTime = null;
        this.stopTime = null;
        this.elapsedTime = 0L;
    }

    public void start() {
        long currentTime = System.currentTimeMillis();
        if (!this.isRunning()) {
            this.startTime = currentTime;
        }
    }

    public void stop() {
        long currentTime = System.currentTimeMillis();
        if (this.isRunning()) {
            this.stopTime = currentTime;
            this.elapsedTime = this.stopTime - this.startTime;
        }
    }
}

