/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;

public class IdleConnectionSweeper
implements DestructableComponent {
    private boolean destroyed;
    private boolean createdTimer;
    private final HttpClient client;
    private final Timer taskTimer;
    private final TimerTask sweeper;

    public IdleConnectionSweeper(@Nonnull HttpClient httpClient, long idleTimeout, long sweepInterval) {
        this(httpClient, idleTimeout, sweepInterval, new Timer(true));
        this.createdTimer = true;
    }

    public IdleConnectionSweeper(@Nonnull HttpClient httpClient, final long idleTimeout, long sweepInterval, @Nonnull Timer backgroundTimer) {
        this.client = Constraint.isNotNull(httpClient, "HttpClient can not be null");
        this.taskTimer = Constraint.isNotNull(backgroundTimer, "Sweeper task timer can not be null");
        this.sweeper = new TimerTask(){

            @Override
            public void run() {
                IdleConnectionSweeper.this.client.getConnectionManager().closeIdleConnections(idleTimeout, TimeUnit.MILLISECONDS);
            }
        };
        this.taskTimer.schedule(this.sweeper, sweepInterval, sweepInterval);
    }

    public long scheduledExecutionTime() {
        if (this.isDestroyed()) {
            throw new DestroyedComponentException();
        }
        return this.sweeper.scheduledExecutionTime();
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public synchronized void destroy() {
        this.sweeper.cancel();
        if (this.createdTimer) {
            this.taskTimer.cancel();
        }
        this.destroyed = true;
    }
}

