/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.resolver;

import javax.annotation.Nullable;

import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.collection.ClassIndexedSet;

/** This class holds instances of {@link Criterion} which are used in resolution or evaluation operations. */
public class CriteriaSet extends ClassIndexedSet<Criterion> implements Criterion {

    /** Constructor. */
    public CriteriaSet() {
    }

    /**
     * A convenience constructor for constructing and adding criteria.
     * 
     * @param criteria criteria to add, may be null or contain null values (which are ignored)
     */
    public CriteriaSet(@Nullable @NullableElements final Criterion... criteria) {
        if (criteria == null || criteria.length == 0) {
            return;
        }

        for (final Criterion criterion : criteria) {
            if (criterion == null) {
                continue;
            }
            add(criterion);
        }
    }

}