/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.scripting;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resource.Resource;
import org.slf4j.Logger;

public final class EvaluableScript
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    private String scriptLanguage = "javascript";
    @NonnullAfterInit
    @NotEmpty
    private String script;
    @NonnullAfterInit
    private ScriptEngine scriptEngine;
    @Nullable
    private CompiledScript compiledScript;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableScript.class);

    @NonnullAfterInit
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(@Nonnull @NotEmpty String what) {
        this.script = Constraint.isNotNull(StringSupport.trimOrNull(what), "Script must not be null or empty");
    }

    public void setScript(@Nonnull InputStream scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source should not be null");
        this.script = StringSupport.inputStreamToString(Constraint.isNotNull(scriptSource, "Script source can not be null or empty"), null);
    }

    public void setScript(@Nonnull File scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source cannot be null");
        if (!scriptSource.exists()) {
            throw new IOException("Script source file " + scriptSource.getAbsolutePath() + " does not exist");
        }
        if (!scriptSource.canRead()) {
            throw new IOException("Script source file " + scriptSource.getAbsolutePath() + " exists but is not readable");
        }
        this.script = Constraint.isNotNull(StringSupport.trimOrNull(Files.asCharSource((File)scriptSource, (Charset)Charset.defaultCharset()).read()), "Script source cannot be empty");
    }

    public void setScript(@Nonnull Resource scriptSource) throws IOException {
        Constraint.isNotNull(scriptSource, "Script source should not be null");
        try (InputStream is = scriptSource.getInputStream();){
            this.setScript(is);
        }
    }

    @Nonnull
    @NotEmpty
    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setEngineName(@Nonnull @NotEmpty String what) {
        this.scriptLanguage = Constraint.isNotNull(StringSupport.trimOrNull(what), "Language must not be null or emoty");
    }

    @Nullable
    public Object eval(@Nonnull Bindings scriptBindings) throws ScriptException {
        this.checkComponentActive();
        if (this.compiledScript != null) {
            return this.compiledScript.eval(scriptBindings);
        }
        return this.scriptEngine.eval(this.script, scriptBindings);
    }

    @Nullable
    public Object eval(@Nonnull ScriptContext scriptContext) throws ScriptException {
        this.checkComponentActive();
        if (this.compiledScript != null) {
            return this.compiledScript.eval(scriptContext);
        }
        return this.scriptEngine.eval(this.script, scriptContext);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.script == null) {
            throw new ComponentInitializationException("Script cannot be null or empty");
        }
        ScriptEngineManager engineManager = new ScriptEngineManager();
        this.scriptEngine = engineManager.getEngineByName(this.scriptLanguage);
        if (this.scriptEngine == null) {
            this.log.debug("Native support for {} not found, trying shibboleth-{}", (Object)this.scriptLanguage, (Object)this.scriptLanguage);
            this.scriptEngine = engineManager.getEngineByName("shibboleth-" + this.scriptLanguage);
        }
        Constraint.isNotNull(this.scriptEngine, "No scripting engine associated with scripting language " + this.scriptLanguage);
        if (this.scriptEngine instanceof Compilable) {
            try {
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.script);
            }
            catch (ScriptException e) {
                throw new ComponentInitializationException(e);
            }
        } else {
            this.compiledScript = null;
        }
    }
}

