/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.error;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ErrorRaisingController {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ErrorRaisingController.class);

    @RequestMapping(value={"/RaiseError"})
    public void raiseError(@Nonnull HttpServletRequest httpRequest) throws Throwable {
        Object exception;
        Object uri = httpRequest.getAttribute("jakarta.servlet.error.request_uri");
        if (uri == null) {
            uri = httpRequest.getAttribute("javax.servlet.error.request_uri");
        }
        if ((exception = httpRequest.getAttribute("jakarta.servlet.error.exception")) == null) {
            exception = httpRequest.getAttribute("javax.servlet.error.exception");
        }
        if (exception == null || !(exception instanceof Exception)) {
            this.log.error("No exception found in request attribute, raising a generic error");
            throw new IllegalArgumentException("No exception found in request attribute");
        }
        Exception e = (Exception)exception;
        this.log.error("Propagating exception thrown by request to {}", uri);
        if (e.getCause() != null) {
            throw e.getCause();
        }
        throw e;
    }
}

