/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import javax.annotation.Nonnull;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class IdentifiableBeanPostProcessor
implements BeanPostProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdentifiableBeanPostProcessor.class);

    @Nonnull
    public Object postProcessBeforeInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        if (bean instanceof IdentifiableComponent) {
            IdentifiableComponent component = (IdentifiableComponent)bean;
            String id = component.getId();
            if (id == null) {
                component.setId(beanName);
            } else if (this.log.isDebugEnabled()) {
                if (id.equals(beanName)) {
                    this.log.trace("The 'id' property is redundant for bean with 'id' attribute '{}'", (Object)beanName);
                } else {
                    this.log.trace("The 'id' property is not the same as the 'id' attribute for bean '{}'!='{}'", (Object)component.getId(), (Object)beanName);
                }
            }
        }
        return bean;
    }

    @Nonnull
    public Object postProcessAfterInitialization(@Nonnull Object bean, @Nonnull String beanName) {
        return bean;
    }
}

