/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.config.BooleanToPredicateConverter;
import net.shibboleth.shared.spring.config.StringBooleanToPredicateConverter;
import net.shibboleth.shared.spring.config.StringToDurationConverter;
import net.shibboleth.shared.spring.config.StringToIPRangeConverter;
import net.shibboleth.shared.spring.config.StringToResourceConverter;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import net.shibboleth.shared.spring.resource.PreferFileSystemResourceLoader;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ApplicationContextBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ApplicationContextBuilder.class);
    @Nullable
    @NotEmpty
    private String contextName;
    @Nullable
    private List<String> configurationSources;
    @Nullable
    private List<Resource> configurationResources;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private List<ApplicationContextInitializer<? super FilesystemGenericApplicationContext>> contextInitializers;
    @Nullable
    private List<BeanFactoryPostProcessor> factoryPostProcessors;
    @Nullable
    private List<BeanPostProcessor> postProcessors;
    @Nullable
    private List<PropertySource<?>> propertySources;
    @Nullable
    private Collection<String> beanProfiles;
    @Nullable
    private ApplicationContext parentContext;
    private boolean installShutdownHook;

    @Nonnull
    public ApplicationContextBuilder setName(@Nullable @NotEmpty String name) {
        this.contextName = StringSupport.trimOrNull((String)name);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setConversionService(@Nullable ConversionService service) {
        this.conversionService = service;
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setServiceConfiguration(@Nonnull Resource config) {
        this.configurationResources = CollectionSupport.singletonList((Object)((Resource)Constraint.isNotNull((Object)config, (String)"Resource cannot be null")));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setUnresolvedServiceConfigurations(@Nonnull Collection<String> configs) {
        this.configurationSources = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configs, (String)"Service configurations cannot be null")));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setServiceConfigurations(@Nonnull Collection<Resource> configs) {
        this.configurationResources = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configs, (String)"Service configurations cannot be null")));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setPropertySources(@Nonnull List<PropertySource<?>> sources) {
        this.propertySources = List.copyOf((Collection)Constraint.isNotNull(sources, (String)"Property sources cannot be null"));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setContextInitializer(@Nonnull ApplicationContextInitializer<? super FilesystemGenericApplicationContext> initializer) {
        Constraint.isNotNull(initializer, (String)"ApplicationContextInitializer cannot be null");
        this.contextInitializers = CollectionSupport.singletonList(initializer);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setContextInitializers(@Nonnull List<ApplicationContextInitializer<? super FilesystemGenericApplicationContext>> initializers) {
        this.contextInitializers = List.copyOf((Collection)Constraint.isNotNull(initializers, (String)"Context initializers cannot be null"));
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanFactoryPostProcessor(@Nonnull BeanFactoryPostProcessor processor) {
        Constraint.isNotNull((Object)processor, (String)"BeanFactoryPostProcessor cannot be null");
        this.factoryPostProcessors = CollectionSupport.singletonList((Object)processor);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanFactoryPostProcessors(@Nonnull List<BeanFactoryPostProcessor> processors) {
        Constraint.isNotNull(processors, (String)"BeanFactoryPostProcessor collection cannot be null");
        this.factoryPostProcessors = CollectionSupport.copyToList(processors);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanPostProcessor(@Nonnull BeanPostProcessor processor) {
        Constraint.isNotNull((Object)processor, (String)"BeanPostProcessor cannot be null");
        this.postProcessors = CollectionSupport.singletonList((Object)processor);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanPostProcessors(@Nonnull List<BeanPostProcessor> processors) {
        Constraint.isNotNull(processors, (String)"BeanPostProcessor collection cannot be null");
        this.postProcessors = CollectionSupport.copyToList(processors);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setBeanProfiles(@Nonnull Collection<String> profiles) {
        this.beanProfiles = StringSupport.normalizeStringCollection(profiles);
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder setParentContext(@Nullable ApplicationContext context) {
        this.parentContext = context;
        return this;
    }

    @Nonnull
    public ApplicationContextBuilder installShutdownHook(boolean flag) {
        this.installShutdownHook = flag;
        return this;
    }

    @Nonnull
    public GenericApplicationContext build() {
        List filtered;
        ApplicationContextAware aware;
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext(this.parentContext);
        context.setDisplayName("ApplicationContext:" + (this.contextName != null ? this.contextName : "anonymous"));
        PreferFileSystemResourceLoader loader = new PreferFileSystemResourceLoader();
        loader.addProtocolResolver(new ConditionalResourceResolver());
        context.setResourceLoader((ResourceLoader)loader);
        if (this.conversionService != null) {
            context.getBeanFactory().setConversionService(this.conversionService);
        } else {
            ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
            Set converters = CollectionSupport.setOf((Object[])new Converter[]{new StringToIPRangeConverter(), new BooleanToPredicateConverter(), new StringBooleanToPredicateConverter(), new StringToResourceConverter(), new StringToDurationConverter()});
            Iterator iterator = converters.iterator();
            while (iterator.hasNext()) {
                ApplicationContextAware aware2;
                Converter c = (Converter)iterator.next();
                if (c instanceof ApplicationContextAware) {
                    aware2 = (ApplicationContextAware)c;
                    aware2.setApplicationContext((ApplicationContext)context);
                }
                if (!(c instanceof EnvironmentAware)) continue;
                aware2 = (EnvironmentAware)c;
                aware2.setEnvironment((Environment)context.getEnvironment());
            }
            service.setConverters(converters);
            service.afterPropertiesSet();
            context.getBeanFactory().setConversionService(service.getObject());
        }
        boolean needPropertyConfigurer = true;
        if (this.factoryPostProcessors != null) {
            for (BeanFactoryPostProcessor bfpp : this.factoryPostProcessors) {
                assert (bfpp != null);
                context.addBeanFactoryPostProcessor(bfpp);
                if (bfpp instanceof PropertySourcesPlaceholderConfigurer) {
                    needPropertyConfigurer = false;
                }
                if (bfpp instanceof ApplicationContextAware) {
                    aware = (ApplicationContextAware)bfpp;
                    aware.setApplicationContext((ApplicationContext)context);
                }
                if (!(bfpp instanceof EnvironmentAware)) continue;
                aware = (EnvironmentAware)bfpp;
                aware.setEnvironment((Environment)context.getEnvironment());
            }
        }
        if (needPropertyConfigurer) {
            PropertySourcesPlaceholderConfigurer propertyConfigurer = new PropertySourcesPlaceholderConfigurer();
            propertyConfigurer.setPlaceholderPrefix("%{");
            propertyConfigurer.setPlaceholderSuffix("}");
            propertyConfigurer.setEnvironment((Environment)context.getEnvironment());
            context.getBeanFactoryPostProcessors().add(propertyConfigurer);
        }
        if (this.postProcessors != null) {
            for (BeanPostProcessor bpp : this.postProcessors) {
                assert (bpp != null);
                context.getBeanFactory().addBeanPostProcessor(bpp);
                if (bpp instanceof ApplicationContextAware) {
                    aware = (ApplicationContextAware)bpp;
                    aware.setApplicationContext((ApplicationContext)context);
                }
                if (!(bpp instanceof EnvironmentAware)) continue;
                aware = (EnvironmentAware)bpp;
                aware.setEnvironment((Environment)context.getEnvironment());
            }
        }
        if (this.beanProfiles != null) {
            String[] profiles = this.beanProfiles.toArray(new String[0]);
            assert (profiles != null);
            context.getEnvironment().setActiveProfiles(profiles);
        }
        if (this.propertySources != null) {
            this.propertySources.forEach(p -> context.getEnvironment().getPropertySources().addLast(p));
            context.getEnvironment().setPlaceholderPrefix("%{");
            context.getEnvironment().setPlaceholderSuffix("}");
        }
        if (this.installShutdownHook) {
            context.registerShutdownHook();
        }
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        if (this.configurationSources != null) {
            this.configurationSources.stream().forEachOrdered(s -> {
                try {
                    assert (s != null);
                    Resource[] loaded = context.getResources((String)s);
                    if (loaded != null && loaded.length > 0) {
                        this.log.debug("Resolved resources: {}", Arrays.asList(loaded));
                        beanDefinitionReader.loadBeanDefinitions(loaded);
                    } else {
                        this.log.debug("No resources resolved from {}", s);
                    }
                }
                catch (IOException e) {
                    this.log.warn("Error loading beans from {}", s, (Object)e);
                }
            });
        }
        if (this.configurationResources != null && !(filtered = (List)((NonnullSupplier)this.configurationResources.stream().filter(r -> {
            if (r.exists()) {
                return true;
            }
            this.log.info("Skipping non-existent resource: {}", r);
            return false;
        }).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get()).isEmpty()) {
            beanDefinitionReader.loadBeanDefinitions(filtered.toArray(new Resource[0]));
        }
        if (this.contextInitializers != null) {
            this.contextInitializers.forEach(i -> i.initialize((ConfigurableApplicationContext)context));
        }
        context.refresh();
        return context;
    }
}

