/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.factory;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;
import org.springframework.beans.factory.BeanCreationException;

public class PatternFactoryBean
extends AbstractComponentAwareFactoryBean<Pattern> {
    @Nullable
    private String caseSensitive;
    @Nullable
    private String regexp;

    @Nonnull
    public Class<?> getObjectType() {
        return Pattern.class;
    }

    @Nullable
    public String getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(@Nullable String what) {
        this.caseSensitive = what;
    }

    @Nullable
    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(@Nullable String what) {
        this.regexp = what;
    }

    @Override
    @Nonnull
    protected Pattern doCreateInstance() throws Exception {
        Boolean isCaseSensitive;
        if (this.regexp == null) {
            throw new BeanCreationException("Regular expression cannot be null");
        }
        if (this.caseSensitive != null) {
            isCaseSensitive = StringSupport.booleanOf((String)this.caseSensitive);
            Constraint.isNotNull((Object)isCaseSensitive, (String)"caseSensitive cannot be null");
        } else {
            isCaseSensitive = true;
        }
        return Pattern.compile(this.regexp, isCaseSensitive != false ? 0 : 2);
    }
}

