/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.factory;

import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.scripting.EvaluableScript;
import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class EvaluableScriptFactoryBean
extends AbstractComponentAwareFactoryBean<EvaluableScript> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableScript.class);
    @Nullable
    private Resource resource;
    @Nullable
    private String script;
    @Nullable
    private String engineName;
    @Nullable
    private String sourceId;

    @Nullable
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(@Nullable Resource what) {
        this.resource = what;
    }

    @Nullable
    public String getScript() {
        return this.script;
    }

    public void setScript(@Nullable String what) {
        this.script = what;
    }

    @Nullable
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(@Nullable String what) {
        this.sourceId = what;
    }

    @Nullable
    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(@Nullable String what) {
        this.engineName = what;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return EvaluableScript.class;
    }

    @Override
    @Nonnull
    protected EvaluableScript doCreateInstance() throws Exception {
        String toExecute;
        if (null == this.script && null == this.resource) {
            this.log.error("{} A script or a resource must be supplied", (Object)this.sourceId);
            throw new BeanCreationException("A script or a resource must be supplied");
        }
        if (null != this.script && null != this.resource) {
            this.log.error("{} Only one of script or resource should be supplied", (Object)this.sourceId);
            throw new BeanCreationException("Only one of script or resource should be supplied");
        }
        if (null != this.resource) {
            try (InputStream is = this.resource.getInputStream();){
                toExecute = StringSupport.inputStreamToString((InputStream)is, null);
            }
        } else {
            toExecute = this.script;
        }
        this.log.debug("{} Language: {} Script: {} ", new Object[]{this.sourceId, this.engineName == null ? "<default>" : this.engineName, this.script});
        if (toExecute != null) {
            EvaluableScript evaluableScript = new EvaluableScript();
            evaluableScript.setScript(toExecute);
            if (this.engineName != null) {
                evaluableScript.setEngineName(this.engineName);
            }
            evaluableScript.initialize();
            return evaluableScript;
        }
        throw new BeanCreationException("Unable to load script");
    }
}

