/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.DestructableComponent;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public abstract class AbstractComponentAwareFactoryBean<T>
extends AbstractFactoryBean<T> {
    protected void destroyInstance(@Nullable T instance) throws Exception {
        super.destroyInstance(instance);
        if (instance instanceof DestructableComponent) {
            ((DestructableComponent)instance).destroy();
        }
    }

    @Nonnull
    protected final T createInstance() throws Exception {
        if (!this.isSingleton()) {
            LoggerFactory.getLogger(AbstractComponentAwareFactoryBean.class).error("Configuration error: {} should not be used to create prototype beans.  Destroy is never called for prototype beans", AbstractComponentAwareFactoryBean.class);
            throw new BeanCreationException("Do not use AbstractComponentAwareFactoryBean to create prototype beans");
        }
        T theBean = this.doCreateInstance();
        if (theBean instanceof InitializableComponent) {
            ((InitializableComponent)theBean).initialize();
        }
        return theBean;
    }

    @Nonnull
    protected abstract T doCreateInstance() throws Exception;
}

