/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.error;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class ExtendedMappingExceptionResolver
extends SimpleMappingExceptionResolver {
    @Nonnull
    private static final String MODEL_ATTR_REQUEST = "request";
    @Nonnull
    private static final String MODEL_ATTR_RESPONSE = "response";
    @Nonnull
    private static final String MODEL_ATTR_SPRINGCONTEXT = "springContext";
    @Nonnull
    private static final String MODEL_ATTR_ENCODER = "encoder";
    @Nullable
    private final Function<HttpServletRequest, Map<String, Object>> viewModelExtenderFunction;

    public ExtendedMappingExceptionResolver() {
        this.viewModelExtenderFunction = null;
    }

    public ExtendedMappingExceptionResolver(@Nullable Function<HttpServletRequest, Map<String, Object>> extender) {
        this.viewModelExtenderFunction = extender;
    }

    protected ModelAndView doResolveException(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nullable Object handler, @Nonnull Exception ex) {
        ModelAndView view = super.doResolveException(request, response, handler, ex);
        if (view != null) {
            view.addObject(MODEL_ATTR_RESPONSE, (Object)response);
        }
        return view;
    }

    @Nonnull
    protected ModelAndView getModelAndView(@Nonnull String viewName, @Nonnull Exception ex, @Nonnull HttpServletRequest request) {
        Map<String, Object> exts;
        Function<HttpServletRequest, Map<String, Object>> local;
        LoggerFactory.getLogger(ex.getClass()).error("", (Throwable)ex);
        ModelAndView view = super.getModelAndView(viewName, ex, request);
        view.addObject(MODEL_ATTR_REQUEST, (Object)request);
        view.addObject(MODEL_ATTR_ENCODER, HTMLEncoder.class);
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        if (context != null) {
            view.addObject(MODEL_ATTR_SPRINGCONTEXT, (Object)context);
        }
        if ((local = this.viewModelExtenderFunction) != null && (exts = local.apply(request)) != null) {
            view.addAllObjects(exts);
        }
        return view;
    }
}

