/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.context;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class AbstractPropertiesApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertiesApplicationContextInitializer.class);

    @Nonnull
    @NotEmpty
    protected abstract String getHomePropertyName();

    @Nonnull
    @NotEmpty
    protected abstract String getSearchTarget();

    @Nonnull
    @NotEmpty
    protected abstract String getSearchLocation();

    @Nonnull
    @NotEmpty
    protected abstract String getFailFastPropertyName();

    @Nonnull
    @NotEmpty
    protected abstract String getAdditionalPropertiesPropertyName();

    @Nonnull
    @NotEmpty
    protected abstract String getAutoSearchPropertyName();

    public void initialize(@Nonnull ConfigurableApplicationContext applicationContext) {
        LOG.debug("Initializing application context '{}'", (Object)applicationContext);
        String searchLocation = this.selectSearchLocation(applicationContext);
        LOG.debug("Attempting to find '{}' at search location '{}'", (Object)this.getSearchTarget(), (Object)searchLocation);
        String searchPath = searchLocation + this.getSearchTarget();
        LOG.debug("Attempting to find resource '{}'", (Object)searchPath);
        Resource resource = applicationContext.getResource(searchPath);
        if (resource.exists()) {
            LOG.debug("Found resource '{}' at search path '{}'", (Object)resource, (Object)searchPath);
            Properties properties = this.loadProperties(null, resource);
            if (properties == null) {
                if (this.isFailFast(applicationContext)) {
                    LOG.error("Unable to load properties from resource '{}'", (Object)resource);
                    throw new ConstraintViolationException("Unable to load properties from resource");
                }
                LOG.warn("Unable to load properties from resource '{}'", (Object)resource);
                return;
            }
            if ("classpath:".equals(searchLocation) || resource instanceof ClassPathResource) {
                this.setHomeProperty(searchLocation, properties);
            } else {
                String searchLocationAbsolutePath = Paths.get(searchLocation, new String[0]).toAbsolutePath().toString();
                if (File.separatorChar == '\\') {
                    searchLocationAbsolutePath = searchLocationAbsolutePath.replace('\\', '/');
                }
                assert (searchLocationAbsolutePath != null);
                this.setHomeProperty(searchLocationAbsolutePath, properties);
            }
            this.loadAdditionalPropertySources(applicationContext, searchLocation, properties);
            this.logProperties(properties);
            this.appendPropertySource(applicationContext, resource.toString(), properties);
        } else {
            if (this.isFailFast(applicationContext)) {
                LOG.error("Unable to find '{}' at '{}'", (Object)this.getSearchTarget(), (Object)searchLocation);
                throw new ConstraintViolationException("Unable to find '" + this.getSearchTarget() + "' at '" + searchLocation + "'");
            }
            LOG.warn("Unable to find '{}' at '{}'", (Object)this.getSearchTarget(), (Object)searchLocation);
        }
    }

    @Nonnull
    @NotEmpty
    protected String selectSearchLocation(@Nonnull ConfigurableApplicationContext applicationContext) {
        Constraint.isNotNull((Object)applicationContext, (String)"Application context cannot be null");
        String homeProperty = applicationContext.getEnvironment().getProperty(this.getHomePropertyName());
        if (homeProperty != null && this.isFailFast(applicationContext)) {
            Constraint.isNotEmpty((String)homeProperty, (String)"idp.home cannot be empty");
            Constraint.isFalse((boolean)homeProperty.endsWith("/"), (String)"idp.home cannot end with '/'");
        }
        return homeProperty != null ? homeProperty : this.getSearchLocation();
    }

    @Nullable
    protected Properties loadProperties(@Nullable Properties sink, @Nonnull Resource resource) {
        Constraint.isNotNull((Object)resource, (String)"Resource cannot be null");
        try {
            Properties holder = new Properties();
            try (InputStream is = resource.getInputStream();){
                String filename = resource.getFilename();
                if (filename != null && filename.endsWith(".xml")) {
                    holder.loadFromXML(is);
                } else {
                    holder.load(is);
                }
            }
            if (sink == null) {
                return holder;
            }
            for (Map.Entry<Object, Object> entry : holder.entrySet()) {
                if (sink.putIfAbsent(entry.getKey(), entry.getValue()) == null) continue;
                LOG.warn("Ignoring duplicate property '{}'", entry.getKey());
            }
            return sink;
        }
        catch (IOException e) {
            LOG.warn("Unable to load properties from resource '{}'", (Object)resource, (Object)e);
            return null;
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Collection<String> getAdditionalSources(@Nonnull String searchLocation, @Nonnull Properties properties) {
        String additionalSources;
        Path searchRoot;
        ArrayList<String> sources = new ArrayList<String>();
        Boolean autosearch = Boolean.valueOf(properties.getProperty(this.getAutoSearchPropertyName(), "false"));
        if (autosearch.booleanValue() && (searchRoot = Path.of(searchLocation, new String[0]).resolve("conf")).toFile().isDirectory()) {
            final Path registryRoot = searchRoot.resolve("attributes");
            final String idpPropertiesNative = Path.of(this.getSearchTarget(), new String[0]).toString();
            try (Stream<Path> paths = Files.find(searchRoot, Integer.MAX_VALUE, new BiPredicate<Path, BasicFileAttributes>(){

                @Override
                public boolean test(Path path, BasicFileAttributes u) {
                    String pathAsString = path.toString();
                    if (u.isRegularFile() && path.getFileName().toString().endsWith(".properties") && !pathAsString.endsWith(idpPropertiesNative) && !pathAsString.startsWith(registryRoot.toString())) {
                        LOG.info("Including auto-located properties in {}", (Object)path);
                        return true;
                    }
                    return false;
                }
            }, FileVisitOption.FOLLOW_LINKS);){
                sources.addAll(paths.map(Path::toString).collect(Collectors.toUnmodifiableList()));
            }
            catch (IOException e) {
                LOG.error("Error searching for additional properties", (Throwable)e);
            }
        }
        if ((additionalSources = properties.getProperty(this.getAdditionalPropertiesPropertyName())) != null) {
            String[] split;
            for (String s : split = additionalSources.split(",")) {
                String trimmedSource = StringSupport.trimOrNull((String)s);
                if (trimmedSource == null) continue;
                sources.add(searchLocation + trimmedSource);
            }
        }
        return sources;
    }

    protected void loadAdditionalPropertySources(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String searchLocation, @Nonnull Properties properties) {
        for (String source : this.getAdditionalSources(searchLocation, properties)) {
            assert (source != null);
            LOG.debug("Attempting to load properties from resource '{}'", (Object)source);
            Resource additionalResource = applicationContext.getResource(source);
            if (additionalResource.exists()) {
                LOG.debug("Found property resource '{}'", (Object)additionalResource);
                if (this.loadProperties(properties, additionalResource) != null) continue;
                if (this.isFailFast(applicationContext)) {
                    LOG.error("Unable to load properties from resource '{}'", (Object)additionalResource);
                    throw new ConstraintViolationException("Unable to load properties from resource");
                }
                LOG.warn("Unable to load properties from resource '{}'", (Object)additionalResource);
                continue;
            }
            LOG.warn("Unable to find property resource '{}' (check {}?)", (Object)additionalResource, (Object)this.getAdditionalPropertiesPropertyName());
        }
    }

    protected void logProperties(@Nonnull Properties properties) {
        if (LOG.isDebugEnabled()) {
            Pattern pattern = Pattern.compile("password|credential|secret|salt|key", 2);
            for (String name : new TreeSet<String>(properties.stringPropertyNames())) {
                String value = pattern.matcher(name).find() ? "<suppressed>" : properties.get(name);
                LOG.debug("Loaded property '{}'='{}'", (Object)name, (Object)value);
            }
        }
    }

    protected void appendPropertySource(@Nonnull ConfigurableApplicationContext applicationContext, @Nonnull String name, @Nonnull Properties properties) {
        applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new PropertiesPropertySource(name, properties));
    }

    protected void setHomeProperty(@Nonnull String path, @Nonnull Properties properties) {
        Constraint.isNotNull((Object)path, (String)"Path cannot be null");
        Constraint.isNotNull((Object)properties, (String)"Properties cannot be null");
        if (properties.getProperty(this.getHomePropertyName()) != null) {
            LOG.debug("Will not set '{}' property because it is already set.", (Object)this.getHomePropertyName());
            return;
        }
        LOG.debug("Setting '{}' property to '{}'", (Object)this.getHomePropertyName(), (Object)path);
        properties.setProperty(this.getHomePropertyName(), path);
    }

    protected boolean isFailFast(@Nonnull ConfigurableApplicationContext applicationContext) {
        Constraint.isNotNull((Object)applicationContext, (String)"Application context cannot be null");
        String failFast = applicationContext.getEnvironment().getProperty(this.getFailFastPropertyName());
        return failFast == null ? true : Boolean.parseBoolean(failFast);
    }
}

