/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.security.impl;

import java.security.InvalidAlgorithmParameterException;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;

/** Generates a type 4 UUID as an identifier. */
@ThreadSafe
public class Type4UUIDIdentifierGenerationStrategy implements IdentifierGenerationStrategy {

    /** Default constructor. */
    public Type4UUIDIdentifierGenerationStrategy() {
        
    }

    /**
     * Constructor.
     * 
     * <p>It is invalid to supply any parameters to this method.</p>
     *
     * @param params must be null
     * 
     * @throws InvalidAlgorithmParameterException if the parameters are non-null
     */
    public Type4UUIDIdentifierGenerationStrategy(@Nonnull final IdentifierGenerationStrategy.ParameterSpec params)
            throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(
                "Type4UUIDIdentifierGenerationStrategy does not support parameters");
    }

    /** {@inheritDoc} */
    @Nonnull @NotEmpty public String generateIdentifier() {
        return generateIdentifier(true);
    }

    /** {@inheritDoc} */
    @Nonnull @NotEmpty public String generateIdentifier(final boolean xmlSafe) {
        if (xmlSafe) {
            return "_" + UUID.randomUUID().toString();
        }
        return UUID.randomUUID().toString();
    }
    
}