/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.security;

import java.security.KeyException;

import javax.annotation.Nullable;

/** Indicates that a key was not found in a key storage facility. */
public class KeyNotFoundException extends KeyException {

    /** Generated UUID. */
    private static final long serialVersionUID = 310860860022348748L;

    /** Constructor. */
    public KeyNotFoundException() {
        
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     */
    public KeyNotFoundException(@Nullable final String message) {
        super(message);
    }

    /**
     * Constructor.
     * 
     * @param wrappedException exception to be wrapped by this one
     */
    public KeyNotFoundException(@Nullable final Exception wrappedException) {
        super(wrappedException);
    }

    /**
     * Constructor.
     * 
     * @param message exception message
     * @param wrappedException exception to be wrapped by this one
     */
    public KeyNotFoundException(@Nullable final String message, @Nullable final Exception wrappedException) {
        super(message, wrappedException);
    }

}