/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.net;

import java.net.InetAddress;

import javax.annotation.Nonnull;

import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Represents a range of IP addresses.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public class IPRange extends net.shibboleth.shared.net.IPRange {

    /**
     * Constructor.
     * 
     * @param address address to base the range on; may be the network address or the
     *                address of a host within the network
     * @param maskSize the number of bits in the netmask
     * 
     * @throws IllegalArgumentException if the address or mask are invalid
     */
    public IPRange(@Nonnull final InetAddress address, final int maskSize) throws IllegalArgumentException {
        super(address, maskSize);
        DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), null,
                net.shibboleth.shared.net.IPRange.class.getName());
    }

    /**
     * Constructor.
     * 
     * @param address address to base the range on; may be the network address or the
     *                address of a host within the network
     * @param maskSize the number of bits in the netmask
     * 
     * @throws IllegalArgumentException if the address or mask are invalid
     */
    public IPRange(@Nonnull final byte[] address, final int maskSize) throws IllegalArgumentException {
        super(address, maskSize);
        DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), null,
                net.shibboleth.shared.net.IPRange.class.getName());
    }
    
    /**
     * Parses a CIDR block definition in to an IP range.
     * 
     * @param cidrBlock the CIDR block definition
     * 
     * @return the resultant IP range
     * 
     * @throws IllegalArgumentException if expression cannot be parsed
     */
    @Nonnull public static net.shibboleth.shared.net.IPRange parseCIDRBlock(@Nonnull @NotEmpty final String cidrBlock)
            throws IllegalArgumentException {
        DeprecationSupport.warn(ObjectType.CLASS, IPRange.class.getName(), null,
                net.shibboleth.shared.net.IPRange.class.getName());
        return net.shibboleth.shared.net.IPRange.parseCIDRBlock(cidrBlock);
    }
    
}