/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;

import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Old support class for using {@link org.apache.hc.client5.http.classic.HttpClient} and related components.
 * 
 * <p>Replaced by {@link net.shibboleth.shared.httpclient.HttpClientSupport}.</p>
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class HttpClientSupport {

    /** Constructor to prevent instantiation. */
    private HttpClientSupport() { }
    
    /**
     * Log deprecation warning.
     */
    private static void deprecation() {
        DeprecationSupport.warn(ObjectType.CLASS, HttpClientSupport.class.getName(), null,
                net.shibboleth.shared.httpclient.HttpClientSupport.class.getName());
    }
    
    /**
     * Build an instance of TLS-capable {@link LayeredConnectionSocketFactory} which uses
     * the standard JSSE default {@link SSLContext} and which performs
     * strict hostname verification.
     * 
     * @return a new instance of HttpClient SSL connection socket factory
     */
    @Nonnull public static LayeredConnectionSocketFactory buildStrictTLSSocketFactory() {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.buildStrictTLSSocketFactory();
    }
    
    /**
     * Build a TLS-capable instance of {@link LayeredConnectionSocketFactory} which accepts all peer certificates
     * and performs no hostname verification.
     * 
     * @return a new instance of HttpClient SSL connection socket factory
     */
    @Nonnull public static LayeredConnectionSocketFactory buildNoTrustTLSSocketFactory() {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.buildNoTrustTLSSocketFactory();
    }
    
    /**
     * Build an instance of {@link X509TrustManager} which trusts all certificates.
     * 
     * @return a new trust manager instance
     */
    @Nonnull public static X509TrustManager buildNoTrustX509TrustManager() {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.buildNoTrustX509TrustManager();
    }

    /**
     * Get the list of {@link HttpClientContextHandler} for the {@link HttpClientContext}.
     *
     * @param context the client context
     * @return the handler list
     */
    @Nonnull public static List<HttpClientContextHandler> getDynamicContextHandlerList(
            @Nonnull final HttpClientContext context) {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.getDynamicContextHandlerList(context);
    }

    /**
     * Add the specified instance of {@link HttpClientContextHandler}
     * to the {@link HttpClientContext} in the first handler list position.
     *
     * @param context the client context
     * @param handler the handler to add
     */
    public static void addDynamicContextHandlerFirst(@Nonnull final HttpClientContext context,
            @Nonnull final HttpClientContextHandler handler) {
        deprecation();
        net.shibboleth.shared.httpclient.HttpClientSupport.addDynamicContextHandlerFirst(context, handler);
    }

    /**
     * Add the specified instance of {@link HttpClientContextHandler}
     * to the {@link HttpClientContext} in the first handler list position.
     *
     * @param context the client context
     * @param handler the handler to add
     * @param uniqueType whether to only add the handler if an instance of its (exact) class is not already present
     */
    public static void addDynamicContextHandlerFirst(@Nonnull final HttpClientContext context,
            @Nonnull final HttpClientContextHandler handler, final boolean uniqueType) {
        deprecation();
        net.shibboleth.shared.httpclient.HttpClientSupport.addDynamicContextHandlerFirst(context, handler, uniqueType);
    }

    /**
     * Add the specified instance of {@link HttpClientContextHandler}
     * to the {@link HttpClientContext} in the last handler list position.
     *
     * @param context the client context
     * @param handler the handler to add
     */
    public static void addDynamicContextHandlerLast(@Nonnull final HttpClientContext context,
            @Nonnull final HttpClientContextHandler handler) {
        deprecation();
        net.shibboleth.shared.httpclient.HttpClientSupport.addDynamicContextHandlerLast(context, handler);
    }

    /**
     * Add the specified instance of {@link HttpClientContextHandler}
     * to the {@link HttpClientContext} in the last handler list position.
     *
     * @param context the client context
     * @param handler the handler to add
     * @param uniqueType whether to only add the handler if an instance of its (exact) class is not already present
     */
    public static void addDynamicContextHandlerLast(@Nonnull final HttpClientContext context,
            @Nonnull final HttpClientContextHandler handler, final boolean uniqueType) {
        deprecation();
        net.shibboleth.shared.httpclient.HttpClientSupport.addDynamicContextHandlerLast(context, handler, uniqueType);
    }

    /**
     * Get the entity content as a String, using the provided default character set
     * if none is found in the entity.
     * 
     * <p>If defaultCharset is null, the default "ISO-8859-1" is used.</p>
     *
     * @param entity must not be null
     * @param defaultCharset character set to be applied if none found in the entity
     * @param maxLength limit on size of content
     * 
     * @return the entity content as a String. May be null if {@link HttpEntity#getContent()} is null.
     *   
     * @throws ParseException if header elements cannot be parsed
     * @throws IOException if an error occurs reading the input stream, or the size exceeds limits
     * @throws UnsupportedCharsetException when the content's charset is not available
     */
    @Nullable public static String toString(@Nonnull final HttpEntity entity, @Nullable final Charset defaultCharset,
            final int maxLength) throws IOException, ParseException {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.toString(entity, defaultCharset, maxLength);
    }
    
    /**
     * Get the entity content as a String, using the provided default character set
     * if none is found in the entity.
     * If defaultCharset is null, the default "ISO-8859-1" is used.
     *
     * @param entity must not be null
     * @param defaultCharset character set to be applied if none found in the entity
     * @param maxLength limit on size of content
     * 
     * @return the entity content as a String. May be null if {@link HttpEntity#getContent()} is null.
     *   
     * @throws ParseException if header elements cannot be parsed
     * @throws IOException if an error occurs reading the input stream, or the size exceeds limits
     * @throws UnsupportedCharsetException when the content's charset is not available
     */
    @Nullable public static String toString(@Nonnull final HttpEntity entity, @Nullable final String defaultCharset,
            final int maxLength) throws IOException, ParseException {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.toString(entity, defaultCharset, maxLength);
    }

    /**
     * Read the contents of an entity and return it as a String.
     * The content is converted using the character set from the entity (if any),
     * failing that, "ISO-8859-1" is used.
     *
     * @param entity the entity to convert to a string; must not be null
     * @param maxLength limit on size of content
     * 
     * @return the entity content as a String. May be null if {@link HttpEntity#getContent()} is null.
     * 
     * @throws ParseException if header elements cannot be parsed
     * @throws IOException if an error occurs reading the input stream, or the size exceeds limits
     * @throws UnsupportedCharsetException when the content's charset is not available
     */
    @Nullable public static String toString(@Nonnull final HttpEntity entity, final int maxLength)
        throws IOException, ParseException {
        deprecation();
        return net.shibboleth.shared.httpclient.HttpClientSupport.toString(entity, maxLength);
    }

}