/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoder.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoder.impl.AbstractOIDCMessageEncoder;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRedirectAuthnRequestEncoder
extends AbstractOIDCMessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectAuthnRequestEncoder.class);

    public boolean test(@Nonnull OIDCAuthorizationConfiguration.OIDCHttpRequestMethod requestMethod) {
        return requestMethod == OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.GET;
    }

    protected void doEncode() throws MessageEncodingException {
        this.log.debug("Encoding OIDC authentication request using Query String Serialization");
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof OIDCAuthenticationRequest)) {
            throw new MessageEncodingException("No outbound OIDC authentication request message contained in message context");
        }
        String redirectURL = this.buildRedirectURL(messageContext, (OIDCAuthenticationRequest)outboundMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        HttpServletSupport.setContentType((HttpServletResponse)response, (String)"application/x-www-form-urlencoded");
        try {
            this.log.trace("Redirecting user-agent to '{}'", (Object)redirectURL);
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    protected String buildRedirectURL(MessageContext messageContext, OIDCAuthenticationRequest request) throws MessageEncodingException {
        if (request.getEndpointURI() == null) {
            throw new MessageEncodingException("No endpoint URI specified, URL can not be built");
        }
        URLBuilder urlBuilder = null;
        try {
            if (request.getEndpointURI() == null) {
                throw new MessageEncodingException("Endpoint URL is null");
            }
            urlBuilder = new URLBuilder(request.getEndpointURI().toString());
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + request.getEndpointURI() + " is not a valid URL", (Exception)e);
        }
        this.serializeAuthorizationParamsToUrl(request, urlBuilder);
        return urlBuilder.buildURL();
    }
}

