/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoder.impl;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoder.impl.AbstractOIDCMessageEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPPostAuthnRequestEncoder
extends AbstractOIDCMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/oidc-request-form-post.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostAuthnRequestEncoder.class);
    @Nullable
    private VelocityEngine velocityEngine;
    @Nonnull
    @NotEmpty
    private String velocityTemplateId = "/templates/oidc-request-form-post.vm";

    public void setVelocityTemplateId(@Nonnull @NotEmpty String newVelocityTemplateId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityTemplateId = Constraint.isNotEmpty((String)newVelocityTemplateId, (String)"Velocity template id must not not be null or empty");
    }

    public void setVelocityEngine(@Nonnull VelocityEngine newVelocityEngine) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.velocityEngine = (VelocityEngine)Constraint.isNotNull((Object)newVelocityEngine, (String)"Velocity engine can not be null");
    }

    public boolean test(@Nonnull OIDCAuthorizationConfiguration.OIDCHttpRequestMethod requestMethod) {
        return requestMethod == OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.POST;
    }

    private VelocityContext doPostEncode(@Nonnull OIDCAuthenticationRequest request) {
        VelocityContext context = new VelocityContext();
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> context.put((String)param.getFirst(), param.getSecond()));
        context.put("action", (Object)HTMLEncoder.encodeForHTMLAttribute((String)request.getEndpointURI().toString()));
        this.log.trace("Velocity context {}", params);
        return context;
    }

    protected void doEncode() throws MessageEncodingException {
        if (this.velocityEngine == null) {
            throw new MessageEncodingException("VelocityEngine must be supplied for form post request mode");
        }
        this.log.debug("Encoding OIDC authentication request using HTTP Form Post Serialization");
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof OIDCAuthenticationRequest)) {
            throw new MessageEncodingException("No outbound OIDC authentication request message contained in message context");
        }
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
            HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
            HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
            VelocityContext context = this.doPostEncode((OIDCAuthenticationRequest)outboundMessage);
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);){
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
            }
        }
        catch (Exception e) {
            this.log.error("Error creating authorization POST request: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error creating authorization POST request", e);
        }
    }
}

