/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoder.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoder.OIDCMessageEncoder;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;

public abstract class AbstractOIDCMessageEncoder
extends AbstractHttpServletResponseMessageEncoder
implements OIDCMessageEncoder {
    protected void serializeAuthorizationParamsToUrl(@Nonnull OIDCAuthenticationRequest request, @Nonnull URLBuilder builder) {
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> builder.getQueryParams().add(param));
    }

    protected String serializeAuthorizationParamsToQueryString(@Nonnull OIDCAuthenticationRequest request) {
        URLBuilder builder = new URLBuilder();
        List<Pair<String, String>> params = this.createParametersFromRequest(request);
        params.forEach(param -> builder.getQueryParams().add(param));
        return builder.buildQueryString();
    }

    protected List<Pair<String, String>> createParametersFromRequest(@Nonnull OIDCAuthenticationRequest req) {
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair((Object)"client_id", (Object)req.getClientID().getValue()));
        params.add(new Pair((Object)"scope", (Object)req.getScope().toString()));
        if (req.getResponseType() != null) {
            params.add(new Pair((Object)"response_type", (Object)req.getResponseType().toString()));
        }
        if (req.getResponseMode() != null) {
            params.add(new Pair((Object)"response_mode", (Object)req.getResponseMode().getValue()));
        }
        if (req.getRedirectURI() != null) {
            params.add(new Pair((Object)"redirect_uri", (Object)req.getRedirectURI().toString()));
        }
        if (req.getState() != null) {
            params.add(new Pair((Object)"state", (Object)req.getState().getValue()));
        }
        if (req.getPrompt() != null) {
            params.add(new Pair((Object)"prompt", (Object)req.getPrompt().toString()));
        }
        if (req.getRequestObject() != null) {
            params.add((Pair<String, String>)new Pair((Object)"request", (Object)req.getRequestObject().serialize()));
        }
        if (req.getNonce() != null) {
            params.add((Pair<String, String>)new Pair((Object)"nonce", (Object)req.getNonce().getValue()));
        }
        if (req.getMaxAge() != null && req.getMaxAge().toSeconds() > 0L) {
            params.add((Pair<String, String>)new Pair((Object)"max_age", (Object)Long.toString(req.getMaxAge().toSeconds())));
        }
        return params;
    }
}

