/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.List;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.encoder.impl.AbstractOIDCMessageEncoder;
import net.shibboleth.oidc.profile.impl.AuthenticationRequestMessageEncoderFactory;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthenticationRequestMessageEncoderFactoryTest {
    private AuthenticationRequestMessageEncoderFactory factory;

    @Test
    public void testNoEncoders() {
        this.factory = new AuthenticationRequestMessageEncoderFactory(null);
        ProfileRequestContext prc = new ProfileRequestContext();
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNull((Object)encoder);
    }

    @Test
    public void testPostEncoder() {
        AbstractOIDCMessageEncoder mockPostEncoder = new AbstractOIDCMessageEncoder(){

            public boolean test(OIDCAuthorizationConfiguration.OIDCHttpRequestMethod method) {
                return method == OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.POST;
            }

            protected void doEncode() throws MessageEncodingException {
            }
        };
        this.factory = new AuthenticationRequestMessageEncoderFactory(List.of(mockPostEncoder));
        ProfileRequestContext prc = new ProfileRequestContext();
        OIDCAuthorizationConfiguration config = new OIDCAuthorizationConfiguration();
        config.setHttpRequestMethodLookupStrategy(rc -> OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.POST.toString());
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
        rpCtx.setProfileConfig((ProfileConfiguration)config);
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNotNull((Object)encoder);
        Assert.assertTrue((encoder == mockPostEncoder ? 1 : 0) != 0);
    }

    @Test
    public void testGetEncoder() {
        AbstractOIDCMessageEncoder mockGetEncoder = new AbstractOIDCMessageEncoder(){

            public boolean test(OIDCAuthorizationConfiguration.OIDCHttpRequestMethod method) {
                return method == OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.GET;
            }

            protected void doEncode() throws MessageEncodingException {
            }
        };
        this.factory = new AuthenticationRequestMessageEncoderFactory(List.of(mockGetEncoder));
        ProfileRequestContext prc = new ProfileRequestContext();
        OIDCAuthorizationConfiguration config = new OIDCAuthorizationConfiguration();
        config.setHttpRequestMethodLookupStrategy(rc -> OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.GET.toString());
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
        rpCtx.setProfileConfig((ProfileConfiguration)config);
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNotNull((Object)encoder);
        Assert.assertTrue((encoder == mockGetEncoder ? 1 : 0) != 0);
    }

    @Test
    public void testNoAvailableEncoder() {
        AbstractOIDCMessageEncoder mockGetEncoder = new AbstractOIDCMessageEncoder(){

            public boolean test(OIDCAuthorizationConfiguration.OIDCHttpRequestMethod method) {
                return method == OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.GET;
            }

            protected void doEncode() throws MessageEncodingException {
            }
        };
        this.factory = new AuthenticationRequestMessageEncoderFactory(List.of(mockGetEncoder));
        ProfileRequestContext prc = new ProfileRequestContext();
        OIDCAuthorizationConfiguration config = new OIDCAuthorizationConfiguration();
        config.setHttpRequestMethodLookupStrategy(rc -> OIDCAuthorizationConfiguration.OIDCHttpRequestMethod.POST.toString());
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
        rpCtx.setProfileConfig((ProfileConfiguration)config);
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNull((Object)encoder);
    }

    @Test
    public void testNullRequestMethod() {
        this.factory = new AuthenticationRequestMessageEncoderFactory(null);
        ProfileRequestContext prc = new ProfileRequestContext();
        OIDCAuthorizationConfiguration config = new OIDCAuthorizationConfiguration();
        config.setHttpRequestMethodLookupStrategy(rc -> null);
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
        rpCtx.setProfileConfig((ProfileConfiguration)config);
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNull((Object)encoder);
    }

    @Test
    public void testNullProfileConfiguration() {
        this.factory = new AuthenticationRequestMessageEncoderFactory(null);
        ProfileRequestContext prc = new ProfileRequestContext();
        RelyingPartyContext rpCtx = (RelyingPartyContext)prc.getSubcontext(RelyingPartyContext.class, true);
        rpCtx.setProfileConfig(null);
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNull((Object)encoder);
    }

    @Test
    public void testNullRelyingPartyContext() {
        this.factory = new AuthenticationRequestMessageEncoderFactory(null);
        ProfileRequestContext prc = new ProfileRequestContext();
        MessageEncoder encoder = this.factory.apply(prc);
        Assert.assertNull((Object)encoder);
    }
}

