/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.decoding.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.oidc.profile.decoding.impl.HTTPPostAuthnResponseDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPPostAuthnResponseDecoderTest {
    private MockHttpServletRequest mockRequest;
    private HTTPPostAuthnResponseDecoder decoder;

    @BeforeMethod
    public void setUp() throws Exception {
        this.decoder = new HTTPPostAuthnResponseDecoder();
        this.mockRequest = new MockHttpServletRequest();
    }

    @Test
    public void testSuccessfulDecoding_Query_AuthCode() throws Exception {
        this.mockRequest.setMethod("POST");
        this.mockRequest.setRequestURI("/idp/profile/Authn/OIDC/RP/callback");
        this.mockRequest.addParameter("state", "91c28622815dd9a92ef7c984c74c9e39.65317332");
        this.mockRequest.addParameter("code", "XSpej7DkB2WYcF1Gzth5CCHw6Oxf3gxR");
        this.mockRequest.setContentType("application/x-www-form-urlencoded");
        this.decoder.setHttpServletRequest((HttpServletRequest)this.mockRequest);
        this.decoder.initialize();
        this.decoder.decode();
        Assert.assertNotNull((Object)this.decoder.getMessageContext());
        Assert.assertNotNull((Object)this.decoder.getMessageContext().getMessage());
        Assert.assertTrue((boolean)(this.decoder.getMessageContext().getMessage() instanceof AuthenticationSuccessResponse));
        Assert.assertTrue((boolean)((AuthenticationResponse)this.decoder.getMessageContext().getMessage()).getState().getValue().equals("91c28622815dd9a92ef7c984c74c9e39.65317332"));
        Assert.assertTrue((boolean)((AuthenticationSuccessResponse)this.decoder.getMessageContext().getMessage()).getAuthorizationCode().getValue().equals("XSpej7DkB2WYcF1Gzth5CCHw6Oxf3gxR"));
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testWrongMethod() throws Exception {
        this.mockRequest.setMethod("GET");
        this.decoder.setHttpServletRequest((HttpServletRequest)this.mockRequest);
        this.decoder.initialize();
        this.decoder.decode();
    }
}

