/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.GrantType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.AbstractOIDCSSOConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OAuth2TokenConfiguration
extends AbstractOIDCSSOConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oauth2/token";
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> grantTypesLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> refreshTokenClaimsSetManipulationStrategyLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> enforceRefreshTokenRotationPredicate;

    public OAuth2TokenConfiguration() {
        this(PROFILE_ID);
        this.grantTypesLookupStrategy = FunctionSupport.constant(Set.of(GrantType.AUTHORIZATION_CODE.toString(), GrantType.REFRESH_TOKEN.toString()));
        this.refreshTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.enforceRefreshTokenRotationPredicate = Predicates.alwaysFalse();
    }

    public OAuth2TokenConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getGrantTypes(@Nullable ProfileRequestContext profileRequestContext) {
        Collection types = this.grantTypesLookupStrategy.apply(profileRequestContext);
        if (types != null) {
            return Set.copyOf(types);
        }
        return Collections.emptySet();
    }

    public void setGrantTypes(@Nonnull @NonnullElements Collection<String> types) {
        Constraint.isNotNull(types, (String)"Collection of types cannot be null");
        this.grantTypesLookupStrategy = types != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(types))) : FunctionSupport.constant(null);
    }

    public void setGrantTypesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.grantTypesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getRefreshTokenClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setRefreshTokenClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.refreshTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setRefreshTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.refreshTokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    public boolean isEnforceRefreshTokenRotation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.enforceRefreshTokenRotationPredicate.test(profileRequestContext);
    }

    public void setEnforceRefreshTokenRotation(boolean flag) {
        this.enforceRefreshTokenRotationPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEnforceRefreshTokenRotationPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.enforceRefreshTokenRotationPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }
}

