/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.idp.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.idp.profile.config.OverriddenIssuerProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class OAuth2TokenAudienceConfiguration
extends AbstractConditionalProfileConfiguration
implements OAuth2ProfileConfiguration,
OverriddenIssuerProfileConfiguration,
AttributeResolvingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROTOCOL_URI = "https://tools.ietf.org/html/rfc6749";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/oauth2/token/audience";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, String> accessTokenTypeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)Duration.ofMinutes(10L));

    public OAuth2TokenAudienceConfiguration() {
        this(PROFILE_ID);
    }

    public OAuth2TokenAudienceConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Nullable
    @NotEmpty
    public String getAccessTokenType(@Nullable ProfileRequestContext profileRequestContext) {
        return this.accessTokenTypeLookupStrategy.apply(profileRequestContext);
    }

    public void setAccessTokenType(@Nullable @NotEmpty String type) {
        this.accessTokenTypeLookupStrategy = FunctionSupport.constant((Object)StringSupport.trimOrNull((String)type));
    }

    public void setAccessTokenTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.accessTokenTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Positive
    public Duration getAccessTokenLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.accessTokenLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        return lifetime;
    }

    public void setAccessTokenLifetime(@Nonnull @Positive Duration lifetime) {
        Constraint.isTrue((lifetime != null && !lifetime.isZero() && !lifetime.isNegative() ? 1 : 0) != 0, (String)"Access token lifetime must be greater than 0");
        this.accessTokenLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAccessTokenLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.accessTokenLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

