/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.AbstractOAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractOAuth2FlowAwareProfileConfiguration
extends AbstractOAuth2ClientAuthenticableProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationCodeFlowPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> implicitFlowPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> hybridFlowPredicate = Predicates.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> refreshTokensPredicate = Predicates.alwaysTrue();

    protected AbstractOAuth2FlowAwareProfileConfiguration(String profileId) {
        super(profileId);
    }

    public boolean isAuthorizationCodeFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authorizationCodeFlowPredicate.test(profileRequestContext);
    }

    public void setAuthorizationCodeFlowEnabled(boolean flag) {
        this.authorizationCodeFlowPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAuthorizationCodeFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.authorizationCodeFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether authorization code flow is supported cannot be null");
    }

    public boolean isHybridFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.hybridFlowPredicate.test(profileRequestContext);
    }

    public void setHybridFlowEnabled(boolean flag) {
        this.hybridFlowPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setHybridFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.hybridFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether implicit flow is supported cannot be null");
    }

    public boolean isImplicitFlowEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.implicitFlowPredicate.test(profileRequestContext);
    }

    public void setImplicitFlowEnabled(boolean flag) {
        this.implicitFlowPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setImplicitFlowEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.implicitFlowPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether hybrid flow is supported cannot be null");
    }

    public boolean isRefreshTokensEnabled(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokensPredicate.test(profileRequestContext);
    }

    public void setRefreshTokensEnabled(boolean flag) {
        this.refreshTokensPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setRefreshTokensEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.refreshTokensPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition used to indicate whether refresh tokens are supported cannot be null");
    }
}

